/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.io.input.AbstractTextReader;
import adams.data.io.input.LineArrayTextReader;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.io.FileInputStream;

public class TextFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;
    protected AbstractTextReader m_Reader;
    protected transient FileInputStream m_Stream;

    @Override
    public String globalInfo() {
        return "Reads a text file and forwards the content.\nThis actor takes the file to read as input.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", new LineArrayTextReader());
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.m_Reader != null) {
            this.m_Reader.reset();
        }
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "reader", this.m_Reader);
    }

    public void setReader(AbstractTextReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractTextReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for reading the content of the text file.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        if (this.m_Reader == null) {
            return new Class[]{Unknown.class};
        }
        return new Class[]{this.m_Reader.generates()};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        FileUtils.closeQuietly(this.m_Stream);
        this.m_Stream = null;
        try {
            this.m_Stream = new FileInputStream(file.getAbsolutePath());
            this.m_Reader.initialize(this.m_Stream);
        }
        catch (Exception e) {
            result = this.handleException("Failed to read text from: " + file, e);
            this.m_Reader.reset();
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Reader != null && this.m_Reader.hasNext();
    }

    @Override
    public Token output() {
        Token result;
        Object obj = this.m_Reader.next();
        if (obj != null) {
            result = new Token(obj);
        } else {
            result = null;
            FileUtils.closeQuietly(this.m_Stream);
        }
        this.m_InputToken = null;
        return result;
    }

    @Override
    public void wrapUp() {
        FileUtils.closeQuietly(this.m_Stream);
        super.wrapUp();
    }
}

