/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractPropertyUpdater;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.PropertyHelper;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.gui.goe.PropertyPath;
import java.util.Hashtable;

public class UpdateProperty
extends AbstractPropertyUpdater
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = 597361990633872666L;
    public static final String BACKUP_INPUT = "input";
    public static final String BACKUP_OUTPUT = "output";
    protected String m_Value;
    protected transient Token m_InputToken;
    protected transient Token m_OutputToken;
    protected transient PropertyPath.PropertyContainer m_Container;

    @Override
    public String globalInfo() {
        return "Updates the property of the object passing through with the specified value.\nUse blank-separated string for updating arrays.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
        this.m_OutputToken = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("value", "value", "");
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The new value for the property.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "value", this.m_Value.isEmpty() ? "-none-" : this.m_Value, ", value: ");
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        if (this.m_OutputToken != null) {
            result.put(BACKUP_OUTPUT, this.m_OutputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        if (state.containsKey(BACKUP_OUTPUT)) {
            this.m_OutputToken = (Token)state.get(BACKUP_OUTPUT);
            state.remove(BACKUP_OUTPUT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
        this.m_OutputToken = null;
    }

    @Override
    public boolean hasInput() {
        return this.m_InputToken != null;
    }

    @Override
    public Token currentInput() {
        return this.m_InputToken;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected void updateProperty(String s) {
        Object value = PropertyHelper.convertValue(this.m_Container, s);
        if (value != null) {
            PropertyPath.setValue(this.m_InputToken.getPayload(), this.m_Property, value);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Property '" + this.m_Property + "' changed to: " + value);
            }
        }
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object obj = this.m_InputToken.getPayload();
            this.m_Container = PropertyPath.find(obj, this.m_Property);
            if (this.m_Container == null) {
                result = "Cannot find property '" + this.m_Property + "' in class '" + obj.getClass().getName() + "'!";
            }
            if (result == null) {
                this.updateProperty(this.m_Value);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to update property: " + this.m_Property, e);
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    protected String postExecute() {
        String result = super.postExecute();
        if (this.isStopped()) {
            this.m_OutputToken = null;
        }
        return result;
    }

    @Override
    public String execute() {
        String result = super.execute();
        if (this.m_Skip) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        this.m_InputToken = null;
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_InputToken = null;
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

