/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.action;

import adams.gui.action.BaseAction;
import adams.gui.core.GUIHelper;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class AbstractBaseAction
extends AbstractAction
implements BaseAction {
    private static final long serialVersionUID = -7695092075151409689L;

    public AbstractBaseAction() {
        this.initialize();
    }

    public AbstractBaseAction(String name) {
        this();
        this.setName(name);
    }

    public AbstractBaseAction(String name, Icon icon) {
        this(name);
        this.setIcon(icon);
    }

    public AbstractBaseAction(String name, String icon) {
        this(name, GUIHelper.getIcon(icon));
    }

    protected void initialize() {
        this.putValue("SwingSelectedKey", false);
    }

    @Override
    public void setName(String value) {
        this.putValue("Name", value);
    }

    @Override
    public String getName() {
        return (String)this.getValue("Name");
    }

    @Override
    public void setIcon(Icon value) {
        this.putValue("SmallIcon", value);
        this.putValue("SwingLargeIconKey", value);
    }

    @Override
    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    @Override
    public void setSelected(boolean value) {
        this.putValue("SwingSelectedKey", value);
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.getValue("SwingSelectedKey");
    }

    @Override
    public void setMnemonic(int value) {
        this.putValue("MnemonicKey", value);
    }

    @Override
    public boolean hasMnemonic() {
        return this.getValue("MnemonicKey") != null;
    }

    @Override
    public KeyStroke getMnemonic() {
        if (this.hasMnemonic()) {
            return (KeyStroke)this.getValue("MnemonicKey");
        }
        return null;
    }

    @Override
    public void setAccelerator(String value) {
        this.putValue("AcceleratorKey", GUIHelper.getKeyStroke(value));
    }

    @Override
    public boolean hasAccelerator() {
        return this.getValue("AcceleratorKey") != null;
    }

    @Override
    public KeyStroke getAccelerator() {
        if (this.hasAccelerator()) {
            return (KeyStroke)this.getValue("AcceleratorKey");
        }
        return null;
    }

    @Override
    public void setToolTipText(String value) {
        this.putValue("ShortDescription", value);
    }

    @Override
    public boolean hasToolTipText() {
        return this.getValue("ShortDescription") != null;
    }

    @Override
    public String getToolTipText() {
        if (this.hasToolTipText()) {
            return (String)this.getValue("ShortDescription");
        }
        return null;
    }

    protected void preActionPerformed(ActionEvent e) {
    }

    protected abstract void doActionPerformed(ActionEvent var1);

    protected void postActionPerformed(ActionEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.preActionPerformed(e);
        this.doActionPerformed(e);
        this.postActionPerformed(e);
    }

    @Override
    public void cleanUp() {
    }
}

