/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.JAIImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.JAIImageWriter;
import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.chooser.ImagePreview;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ImageFileChooser
extends AbstractConfigurableExtensionFileFilterFileChooser<AbstractImageReader, AbstractImageWriter> {
    private static final long serialVersionUID = -4519042048473978377L;
    protected JCheckBox m_CheckBoxPreview;
    protected ImagePreview m_ImagePreview;
    protected static List<ExtensionFileFilterWithClass> m_ReaderFileFilters;
    protected static List<ExtensionFileFilterWithClass> m_WriterFileFilters;

    public ImageFileChooser() {
    }

    public ImageFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public ImageFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected JComponent createAccessoryPanel() {
        JPanel config = (JPanel)super.createAccessoryPanel();
        this.m_CheckBoxPreview = new JCheckBox("Preview");
        this.m_CheckBoxPreview.setMnemonic('P');
        this.m_CheckBoxPreview.setSelected(false);
        this.m_CheckBoxPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageFileChooser.this.m_ImagePreview.setVisible(ImageFileChooser.this.m_CheckBoxPreview.isSelected());
            }
        });
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.m_CheckBoxPreview, "North");
        JPanel panel = new JPanel(new BorderLayout());
        result.add((Component)panel, "Center");
        this.m_ImagePreview = new ImagePreview(this);
        this.m_ImagePreview.setVisible(false);
        panel.add((Component)config, "Center");
        panel.add((Component)this.m_ImagePreview, "South");
        Dimension dim = this.getDefaultAccessoryDimension();
        if (dim != null) {
            result.setSize(dim);
            result.setMinimumSize(dim);
            result.setPreferredSize(dim);
        }
        return result;
    }

    @Override
    protected ExtensionFileFilterWithClass getDefaultFileFilter(int dialogType) {
        ExtensionFileFilterWithClass result = null;
        boolean found = false;
        if (dialogType == 0) {
            String preferred = GUIHelper.getString("PreferredImageReader", "png");
            for (ExtensionFileFilterWithClass reader : m_ReaderFileFilters) {
                for (String ext : reader.getExtensions()) {
                    if (!ext.equalsIgnoreCase(preferred)) continue;
                    found = true;
                    result = reader;
                    break;
                }
                if (!found) continue;
                break;
            }
        } else if (dialogType == 1) {
            String preferred = GUIHelper.getString("PreferredImageWriter", "png");
            for (ExtensionFileFilterWithClass writer : m_WriterFileFilters) {
                for (String ext : writer.getExtensions()) {
                    if (!ext.equalsIgnoreCase(preferred)) continue;
                    found = true;
                    result = writer;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        if (!found) {
            result = super.getDefaultFileFilter(dialogType);
        }
        return result;
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return m_ReaderFileFilters;
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters;
    }

    public AbstractImageReader getImageReader() {
        this.configureCurrentHandlerHook(0);
        if (this.m_CurrentHandler instanceof AbstractImageReader) {
            return (AbstractImageReader)this.m_CurrentHandler;
        }
        return null;
    }

    public AbstractImageWriter getImageWriter() {
        this.configureCurrentHandlerHook(1);
        if (this.m_CurrentHandler instanceof AbstractImageWriter) {
            return (AbstractImageWriter)this.m_CurrentHandler;
        }
        return null;
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters != null;
    }

    @Override
    protected void doInitializeFilters() {
        ImageFileChooser.initFilters(true, AbstractImageReader.getReaders());
        ImageFileChooser.initFilters(false, AbstractImageWriter.getWriters());
    }

    protected static void initFilters(boolean reader, String[] classnames) {
        if (reader) {
            m_ReaderFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        } else {
            m_WriterFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        }
        for (int i = 0; i < classnames.length; ++i) {
            ExtensionFileFilterWithClass filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames[i];
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    if (!((AbstractImageReader)converter).isAvailable()) continue;
                    desc = ((AbstractImageReader)converter).getFormatDescription();
                    ext = ((AbstractImageReader)converter).getFormatExtensions();
                } else {
                    if (!((AbstractImageWriter)converter).isAvailable()) continue;
                    desc = ((AbstractImageWriter)converter).getFormatDescription();
                    ext = ((AbstractImageWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to set up '" + classname + "':");
                e.printStackTrace();
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ExtensionFileFilterWithClass(classname, desc, ext);
                m_ReaderFileFilters.add(filter);
                continue;
            }
            filter = new ExtensionFileFilterWithClass(classname, desc, ext);
            m_WriterFileFilters.add(filter);
        }
        if (reader) {
            Collections.sort(m_ReaderFileFilters);
        } else {
            Collections.sort(m_WriterFileFilters);
        }
    }

    @Override
    protected AbstractImageReader getDefaultReader() {
        return new JAIImageReader();
    }

    @Override
    protected AbstractImageWriter getDefaultWriter() {
        return new JAIImageWriter();
    }

    public AbstractImageReader getReaderForFile(File file) {
        AbstractImageReader result = null;
        for (ExtensionFileFilterWithClass filter : m_ReaderFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (AbstractImageReader)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate reader '" + filter.getClassname() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public AbstractImageWriter getWriterForFile(File file) {
        AbstractImageWriter result = null;
        for (ExtensionFileFilterWithClass filter : m_WriterFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (AbstractImageWriter)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate writer '" + filter.getClassname() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected Class getReaderClass() {
        return AbstractImageReader.class;
    }

    @Override
    protected Class getWriterClass() {
        return AbstractImageWriter.class;
    }
}

