/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.management.CharsetHelper;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.chooser.FileChooserBookmarksPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TextFileChooser
extends BaseFileChooser {
    private static final long serialVersionUID = -810326731112492794L;
    protected FileEncodingPanel m_PanelEncoding;

    public TextFileChooser() {
    }

    public TextFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public TextFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PanelEncoding = new FileEncodingPanel();
        this.m_PanelEncoding.setOwner(this);
        Dimension dim = this.getDefaultAccessoryDimension();
        if (dim != null) {
            this.m_PanelEncoding.setSize(dim);
            this.m_PanelEncoding.setMinimumSize(dim);
            this.m_PanelEncoding.setPreferredSize(dim);
        }
        this.setAccessory(this.m_PanelEncoding);
        ExtensionFileFilter filter = ExtensionFileFilter.getTextFileFilter();
        this.addChoosableFileFilter(filter);
        this.addChoosableFileFilter(ExtensionFileFilter.getLogFileFilter());
        this.addChoosableFileFilter(ExtensionFileFilter.getCsvFileFilter());
        this.addChoosableFileFilter(ExtensionFileFilter.getPropertiesFileFilter());
        this.setFileFilter(filter);
        this.setDefaultExtension(ExtensionFileFilter.getTextFileFilter().getExtensions()[0]);
        this.setAutoAppendExtension(true);
    }

    public void setEncoding(String value) {
        this.m_PanelEncoding.setEncoding(value);
    }

    public String getEncoding() {
        return this.m_PanelEncoding.getEncoding();
    }

    public static class FileEncodingPanel
    extends BasePanel {
        private static final long serialVersionUID = -2064293687093129577L;
        protected FileChooserBookmarksPanel m_PanelBookmarks;
        protected JPanel m_PanelEncoding;
        protected JLabel m_LabelEncoding;
        protected JComboBox m_ComboBoxEncoding;
        protected Color m_DefaultBackground;

        @Override
        protected void initialize() {
            super.initialize();
            this.m_DefaultBackground = this.getBackground();
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PanelBookmarks = new FileChooserBookmarksPanel();
            this.m_PanelBookmarks.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.add((Component)((Object)this.m_PanelBookmarks), "Center");
            this.m_PanelEncoding = new JPanel(new BorderLayout(0, 5));
            this.m_PanelEncoding.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
            this.add((Component)this.m_PanelEncoding, "North");
            this.m_ComboBoxEncoding = new JComboBox<String>(CharsetHelper.getIDs());
            this.m_ComboBoxEncoding.setSelectedItem(CharsetHelper.getSingleton().getCharset().name());
            this.m_LabelEncoding = new JLabel("Encoding");
            this.m_LabelEncoding.setLabelFor(this.m_ComboBoxEncoding);
            this.m_PanelEncoding.add((Component)this.m_LabelEncoding, "North");
            this.m_PanelEncoding.add((Component)this.m_ComboBoxEncoding, "Center");
        }

        public void setOwner(JFileChooser value) {
            this.m_PanelBookmarks.setOwner(value);
        }

        public JFileChooser getOwner() {
            return this.m_PanelBookmarks.getOwner();
        }

        public void setEncoding(String value) {
            this.m_ComboBoxEncoding.setSelectedItem(value);
            if (this.m_ComboBoxEncoding.getSelectedIndex() == -1) {
                this.m_ComboBoxEncoding.setSelectedItem(0);
            }
        }

        public String getEncoding() {
            return this.m_ComboBoxEncoding.getSelectedItem().toString();
        }

        public static boolean isValidEncoding(String value) {
            try {
                Charset.forName(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

