/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Utils;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractBaseTableModel
extends AbstractTableModel
implements SpreadSheetSupporter {
    private static final long serialVersionUID = 1379439060928152100L;

    @Override
    public SpreadSheet toSpreadSheet() {
        int i;
        SpreadSheet result = new SpreadSheet();
        Row row = result.getHeaderRow();
        for (i = 0; i < this.getColumnCount(); ++i) {
            row.addCell("" + i).setContent(this.getColumnName(i));
        }
        for (int n = 0; n < this.getRowCount(); ++n) {
            row = result.addRow("" + result.getRowCount());
            for (i = 0; i < this.getColumnCount(); ++i) {
                Object value = this.getValueAt(n, i);
                if (value == null) {
                    row.addCell("" + i).setContent("?");
                    continue;
                }
                if (value.getClass().isArray()) {
                    row.addCell("" + i).setContent(Utils.arrayToString(value));
                    continue;
                }
                if (value instanceof Integer) {
                    row.addCell("" + i).setContent((Integer)value);
                    continue;
                }
                if (value instanceof Double) {
                    row.addCell("" + i).setContent((Double)value);
                    continue;
                }
                row.addCell("" + i).setContent("" + value);
            }
        }
        return result;
    }

    public String toString() {
        return this.toSpreadSheet().toString();
    }
}

