/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.source.StorageValue;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.MakePlotContainer;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.PlotColumn;
import adams.gui.core.spreadsheettable.PlotRow;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItem;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Dialog;
import java.util.ArrayList;
import javax.swing.SwingWorker;

public class SimplePlot
extends AbstractOptionHandler
implements PlotColumn,
PlotRow {
    private static final long serialVersionUID = -5624002368001818142L;

    @Override
    public String globalInfo() {
        return "Allows to generate a histogram from a spreadsheet row or column";
    }

    @Override
    public String getMenuItem() {
        return "Simple plot...";
    }

    @Override
    public String getIconName() {
        return "plot.gif";
    }

    @Override
    public int compareTo(SpreadSheetTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    protected void plot(final SpreadSheetTable table, SpreadSheet sheet, final boolean isColumn, int index) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog(table) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog(table), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame(table), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(AbstractActor.class);
        setup.getGOEEditor().setCanChangeClassInDialog(false);
        adams.flow.sink.SimplePlot last = (adams.flow.sink.SimplePlot)table.getLastSetup(this.getClass(), true, !isColumn);
        if (last == null) {
            last = new adams.flow.sink.SimplePlot();
        }
        setup.setCurrent(last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent(table));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return;
        }
        last = (adams.flow.sink.SimplePlot)setup.getCurrent();
        table.addLastSetup(this.getClass(), true, !isColumn, last);
        final ArrayList<Double> list = new ArrayList<Double>();
        if (isColumn) {
            for (int i = 0; i < sheet.getRowCount(); ++i) {
                if (!sheet.hasCell(i, index) || !sheet.getCell(i, index).isNumeric()) continue;
                list.add(sheet.getCell(i, index).toDouble());
            }
        } else {
            for (int i = 0; i < sheet.getColumnCount(); ++i) {
                if (!sheet.hasCell(index, i) || !sheet.getCell(index, i).isNumeric()) continue;
                list.add(sheet.getCell(index, i).toDouble());
            }
        }
        final String title = isColumn ? "Column " + (index + 1) + "/" + sheet.getColumnName(index) : "Row " + (index + 1);
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Flow flow = new Flow();
                StorageValue sv = new StorageValue();
                sv.setStorageName(new StorageName("values"));
                flow.add(sv);
                ArrayToSequence a2s = new ArrayToSequence();
                flow.add(a2s);
                MakePlotContainer mpc = new MakePlotContainer();
                mpc.setPlotName(title);
                flow.add(mpc);
                Object last = table.getLastSetup(SimplePlot.this.getClass(), true, !isColumn);
                adams.flow.sink.SimplePlot plot = (adams.flow.sink.SimplePlot)((adams.flow.sink.SimplePlot)last).shallowCopy();
                plot.setShortTitle(true);
                plot.setName(title);
                plot.setX(-2);
                plot.setY(-2);
                flow.add(plot);
                flow.setUp();
                flow.getStorage().put(new StorageName("values"), list.toArray(new Double[list.size()]));
                flow.execute();
                flow.wrapUp();
                return null;
            }
        };
        worker.execute();
    }

    @Override
    public boolean plotColumn(SpreadSheetTable table, SpreadSheet sheet, int column) {
        this.plot(table, sheet, true, column);
        return true;
    }

    @Override
    public boolean plotRow(SpreadSheetTable table, SpreadSheet sheet, int row) {
        this.plot(table, sheet, false, row);
        return true;
    }
}

