/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.core.ClassLocator;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.logging.LoggingHelper;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.transformer.PassThrough;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActorSuggestion {
    private static final Logger LOGGER = LoggingHelper.getConsoleLogger(ActorSuggestion.class);
    public static final String FILENAME = "ActorSuggestion.props";
    public static final String KEY_DEFAULT = "Default";
    public static final String FILENAME_ADDHISTORY = "FlowAddHistory.csv";
    protected Properties m_Properties;
    protected AbstractActor[] m_Defaults;
    protected String[] m_Rules;
    protected static ActorSuggestion m_Singleton;

    private ActorSuggestion() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Properties = Environment.getInstance().read("actor suggestion");
        String[] parts = this.m_Properties.getProperty(KEY_DEFAULT, "adams.flow.transformer.PassThrough").split(",");
        ArrayList<AbstractActor> actors = new ArrayList<AbstractActor>();
        for (int i = 0; i < parts.length; ++i) {
            try {
                actors.add((AbstractActor)Class.forName(parts[i]).newInstance());
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate default actor '" + parts[i] + "':");
                e.printStackTrace();
            }
        }
        if (actors.size() == 0) {
            actors.add(new PassThrough());
        }
        this.m_Defaults = actors.toArray(new AbstractActor[actors.size()]);
        LOGGER.info("Defaults: " + Utils.arrayToString(this.m_Defaults, true));
        ArrayList<String> rules = new ArrayList<String>();
        Enumeration<?> names = this.m_Properties.propertyNames();
        adams.parser.ActorSuggestion suggestion = new adams.parser.ActorSuggestion();
        suggestion.setParent(new Flow());
        suggestion.setPosition(0);
        suggestion.setActors(new AbstractActor[0]);
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.equals(KEY_DEFAULT)) continue;
            String rule = this.m_Properties.getProperty(name);
            try {
                suggestion.setExpression(rule);
                suggestion.evaluate();
                rules.add(rule);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Invalid actor suggestion rule: " + rule, e);
            }
        }
        this.m_Rules = rules.toArray(new String[rules.size()]);
        LOGGER.info("Rules: " + Utils.arrayToString(this.m_Rules));
    }

    public AbstractActor[] getDefaults() {
        return this.m_Defaults;
    }

    public AbstractActor[] suggest(AbstractActor parent, int position, AbstractActor[] actors) {
        ArrayList<AbstractActor> suggestions = new ArrayList<AbstractActor>();
        Class[] restrictions = ((ActorHandler)((Object)parent)).getActorHandlerInfo().getRestrictions();
        try {
            AbstractActor[] suggested = adams.parser.ActorSuggestion.evaluate(this.m_Rules, parent, position, actors);
            for (int i = 0; i < suggested.length; ++i) {
                if (suggested[i] != null && restrictions.length > 0) {
                    boolean match = false;
                    for (Class cls : restrictions) {
                        try {
                            if (cls.isInterface()) {
                                match = match || ClassLocator.hasInterface(cls, suggested[i].getClass());
                                continue;
                            }
                            match = match || ClassLocator.isSubclass(cls, suggested[i].getClass());
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "Failed to process suggestion ('" + parent.getClass().getName() + "'): " + cls.getName(), e);
                        }
                    }
                    if (!match) {
                        suggested[i] = null;
                    }
                }
                if (suggested[i] == null) continue;
                suggestions.add(suggested[i]);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to suggest actors:");
            e.printStackTrace();
        }
        AbstractActor[] result = suggestions.toArray(new AbstractActor[suggestions.size()]);
        LOGGER.info("suggest: parent=" + parent.getClass().getName() + ", " + "position=" + position + ", " + "actors=" + Utils.arrayToString(actors, true) + "\n" + "--> " + Utils.arrayToString(result, true));
        return result;
    }

    protected void record(Actor actor, StringBuilder line) {
        if (line.length() > 0) {
            line.append(",");
        }
        if (actor != null) {
            line.append(actor.getClass().getName());
        }
        line.append(",");
        if (actor != null) {
            line.append(ActorUtils.getFunctionalAspect(actor));
        }
        line.append(",");
        if (actor != null) {
            line.append(ActorUtils.getProceduralAspect(actor));
        }
        line.append(",");
        if (actor != null) {
            line.append(ActorUtils.isControlActor(actor) ? "true" : "false");
        }
    }

    protected void record(Actor added, Actor parent, Actor before, Actor after, Tree.InsertPosition position) {
        StringBuilder line;
        String filename = Environment.getInstance().getHome() + File.separator + FILENAME_ADDHISTORY;
        if (!new File(filename).exists()) {
            line = new StringBuilder();
            line.append("Actor-Class");
            line.append(",");
            line.append("Actor-Functional");
            line.append(",");
            line.append("Actor-Procedural");
            line.append(",");
            line.append("Actor-Control");
            line.append(",");
            line.append("Parent-Class");
            line.append(",");
            line.append("Parent-Functional");
            line.append(",");
            line.append("Parent-Procedural");
            line.append(",");
            line.append("Parent-Control");
            line.append(",");
            line.append("Before-Class");
            line.append(",");
            line.append("Before-Functional");
            line.append(",");
            line.append("Before-Procedural");
            line.append(",");
            line.append("Before-Control");
            line.append(",");
            line.append("After-Class");
            line.append(",");
            line.append("After-Functional");
            line.append(",");
            line.append("After-Procedural");
            line.append(",");
            line.append("After-Control");
            line.append(",");
            line.append("Position");
            FileUtils.writeToFile(filename, (Object)line, false);
        }
        line = new StringBuilder();
        this.record(added, line);
        this.record(parent, line);
        this.record(before, line);
        this.record(after, line);
        line.append(",");
        line.append(position.toString());
        FileUtils.writeToFile(filename, (Object)line, true);
    }

    public void record(Node added, Node parent, Tree.InsertPosition position) {
        AbstractActor addedActor = added.getActor();
        AbstractActor parentActor = parent.getActor();
        AbstractActor beforeActor = null;
        AbstractActor afterActor = null;
        if (added.getPreviousSibling() != null) {
            beforeActor = ((Node)added.getPreviousSibling()).getActor();
        }
        if (added.getNextSibling() != null) {
            afterActor = ((Node)added.getNextSibling()).getActor();
        }
        this.record(addedActor, parentActor, beforeActor, afterActor, position);
    }

    public static synchronized ActorSuggestion getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new ActorSuggestion();
        }
        return m_Singleton;
    }
}

