/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import adams.gui.core.GUIHelper;
import adams.gui.flow.tree.ActorTemplateSuggestion;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.Tree;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import adams.gui.goe.GenericObjectEditorDialog;
import javax.swing.tree.TreePath;

public abstract class AbstractFromTemplateAction
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = -658661047850659634L;

    protected AbstractActorTemplate[] suggestActorTemplates(TreePath path, Tree.InsertPosition position) {
        AbstractActorTemplate[] result = null;
        if (result == null) {
            int pos;
            Node parentNode;
            if (position == Tree.InsertPosition.BENEATH) {
                parentNode = TreeHelper.pathToNode(path);
                pos = parentNode.getChildCount();
            } else {
                Node node = TreeHelper.pathToNode(path);
                parentNode = (Node)node.getParent();
                pos = parentNode.getIndex(node);
                if (position == Tree.InsertPosition.AFTER) {
                    ++pos;
                }
            }
            AbstractActor parent = parentNode.getActor();
            AbstractActor[] actors = new AbstractActor[parentNode.getChildCount()];
            for (int i = 0; i < actors.length; ++i) {
                actors[i] = ((Node)parentNode.getChildAt(i)).getActor();
            }
            AbstractActorTemplate[] suggestions = ActorTemplateSuggestion.getSingleton().suggest(parent, pos, actors);
            if (suggestions.length > 0) {
                result = suggestions;
            }
        }
        if (result == null) {
            result = ActorTemplateSuggestion.getSingleton().getDefaults();
        }
        return result;
    }

    protected void addFromTemplate(TreePath path, AbstractActorTemplate template, Tree.InsertPosition position) {
        AbstractActor actor;
        Object[] templates;
        GenericObjectEditorDialog m_TemplateDialog = GenericObjectEditorDialog.createDialog(((StateContainer)this.m_State).tree);
        m_TemplateDialog.getGOEEditor().setCanChangeClassInDialog(true);
        m_TemplateDialog.getGOEEditor().setClassType(AbstractActorTemplate.class);
        if (template == null) {
            templates = this.suggestActorTemplates(path, position);
            template = templates[0];
        } else {
            templates = new AbstractActorTemplate[]{template};
        }
        m_TemplateDialog.setProposedClasses(templates);
        m_TemplateDialog.setCurrent(template);
        if (position == Tree.InsertPosition.HERE) {
            m_TemplateDialog.setTitle("Add from template here...");
        } else if (position == Tree.InsertPosition.AFTER) {
            m_TemplateDialog.setTitle("Add from template after...");
        } else if (position == Tree.InsertPosition.BENEATH) {
            m_TemplateDialog.setTitle("Add from template beneath...");
        }
        m_TemplateDialog.setLocationRelativeTo(GUIHelper.getParentComponent(((StateContainer)this.m_State).tree));
        m_TemplateDialog.setVisible(true);
        if (m_TemplateDialog.getResult() != 0) {
            return;
        }
        template = (AbstractActorTemplate)m_TemplateDialog.getEditor().getValue();
        try {
            actor = template.generate();
            ((StateContainer)this.m_State).tree.updateLastTemplate(template, position);
        }
        catch (Exception e) {
            actor = null;
            e.printStackTrace();
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Failed to create actor from template: " + e);
        }
        if (actor != null) {
            ((StateContainer)this.m_State).tree.addActor(path, actor, position);
        }
    }
}

