/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.base.BaseAnnotation;
import adams.flow.core.AbstractActor;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import java.awt.event.ActionEvent;
import javax.swing.tree.DefaultTreeModel;

public class AnnotateActor
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Annotate actor";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).numSel == 1);
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        Node node = TreeHelper.pathToNode(((StateContainer)this.m_State).selPath);
        this.addUndoPoint("Annotating " + node.getFullName());
        AbstractActor actor = node.getActor();
        String annotationOld = actor.getAnnotations().getValue();
        String annotationNew = GUIHelper.showInputDialog(GUIHelper.getParentComponent(((StateContainer)this.m_State).tree), "Please enter new annotation:", annotationOld);
        if (annotationNew == null) {
            return;
        }
        if (annotationNew.equals(annotationOld)) {
            return;
        }
        actor.setAnnotations(new BaseAnnotation(annotationNew));
        node.setActor(actor);
        ((DefaultTreeModel)((StateContainer)this.m_State).tree.getModel()).nodeChanged(node);
        ((StateContainer)this.m_State).tree.setModified(true);
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, node, ActorChangeEvent.Type.MODIFY));
    }
}

