/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.Utils;
import adams.core.io.FlowFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.ExternalActorHandler;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;

public class MaterializeExternalActor
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Materialize external actor";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).numSel == 1 && ((StateContainer)this.m_State).selNode.getActor() instanceof ExternalActorHandler);
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        Node currNode = ((StateContainer)this.m_State).selNode;
        Node parent = ((StateContainer)this.m_State).parent;
        ExternalActorHandler handler = (ExternalActorHandler)((Object)currNode.getActor());
        ArrayList<String> errors = new ArrayList<String>();
        FlowFile file = handler.getActorFile();
        AbstractActor actor = ActorUtils.read(((File)file).getAbsolutePath(), errors);
        if (actor == null) {
            if (errors.size() == 0) {
                GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Failed to materialize external flow: " + file);
            } else {
                GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Failed to materialize external flow: " + file + "\n" + Utils.flatten(errors, "\n"));
            }
            return;
        }
        this.addUndoPoint("Materializing external actor '" + file + "'");
        Node newNode = ((StateContainer)this.m_State).tree.buildTree(null, actor, false);
        int index = parent.getIndex(currNode);
        parent.remove(index);
        parent.insert(newNode, index);
        currNode = newNode;
        ((StateContainer)this.m_State).tree.updateActorName(currNode);
        ((StateContainer)this.m_State).tree.setModified(true);
        ((StateContainer)this.m_State).tree.nodeStructureChanged(currNode);
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, currNode, ActorChangeEvent.Type.MODIFY));
        ((StateContainer)this.m_State).tree.locateAndDisplay(currNode.getFullName());
        ((StateContainer)this.m_State).tree.refreshTabs();
    }
}

