/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.postprocessor;

import adams.core.ClassLister;
import adams.core.Utils;
import adams.core.logging.LoggingObject;
import adams.flow.core.AbstractActor;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.flow.tree.Tree;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public abstract class AbstractEditPostProcessor
extends LoggingObject {
    private static final long serialVersionUID = -1710283049516306816L;

    public abstract boolean applies(AbstractActor var1, AbstractActor var2, AbstractActor var3);

    protected List<TreePath> backupExpandedState(Tree tree) {
        return tree.getExpandedNodes();
    }

    protected boolean restoreExpandedState(Tree tree, List<TreePath> expanded) {
        return tree.restoreExpandedNodes(expanded);
    }

    public abstract boolean postProcess(Tree var1, AbstractActor var2, AbstractActor var3, AbstractActor var4);

    public static String[] getPostProcessors() {
        return ClassLister.getSingleton().getClassnames(AbstractEditPostProcessor.class);
    }

    public static boolean apply(Tree tree, AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        String[] processors;
        boolean result = false;
        boolean confirmed = false;
        for (String processor : processors = AbstractEditPostProcessor.getPostProcessors()) {
            try {
                AbstractEditPostProcessor proc = (AbstractEditPostProcessor)Class.forName(processor).newInstance();
                if (!proc.applies(parent, oldActor, newActor)) continue;
                if (!confirmed) {
                    if (JOptionPane.showConfirmDialog(GUIHelper.getParentComponent(tree), "Propagate changes throughout the tree (if applicable)?") != 0) break;
                    confirmed = true;
                }
                List<TreePath> exp = proc.backupExpandedState(tree);
                boolean modified = proc.postProcess(tree, parent, oldActor, newActor);
                if (modified) {
                    proc.restoreExpandedState(tree, exp);
                }
                exp = null;
                result |= modified;
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, "Error applying edit post-processor '" + processor + "':\n" + Utils.throwableToString(e));
            }
        }
        return result;
    }
}

