/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.postprocessor;

import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorHandler;
import adams.flow.processor.UpdateCallableActorName;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.flow.tree.postprocessor.AbstractEditPostProcessor;

public class CallableActorRenamed
extends AbstractEditPostProcessor {
    private static final long serialVersionUID = 4776606137570074080L;

    public String globalInfo() {
        return "Updates all references of the callable actor that was renamed.";
    }

    @Override
    public boolean applies(AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        return parent instanceof CallableActorHandler && !oldActor.getName().equals(newActor.getName());
    }

    @Override
    public boolean postProcess(Tree tree, AbstractActor parent, AbstractActor oldActor, AbstractActor newActor) {
        boolean result = false;
        UpdateCallableActorName updater = new UpdateCallableActorName();
        updater.setOldName(oldActor.getName());
        updater.setNewName(newActor.getName());
        updater.process(tree.getActor());
        if (updater.isModified()) {
            result = true;
            tree.setModified(true);
            tree.setActor(updater.getModifiedActor());
            tree.notifyActorChangeListeners(new ActorChangeEvent(tree, new Node[0], ActorChangeEvent.Type.MODIFY_BULK));
            tree.refreshTabs();
        }
        return result;
    }
}

