/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLister;
import adams.core.ClassLocator;
import adams.core.Properties;
import adams.env.Environment;
import adams.gui.goe.BooleanEditor;
import adams.gui.goe.ByteEditor;
import adams.gui.goe.DoubleEditor;
import adams.gui.goe.EnumEditor;
import adams.gui.goe.FloatEditor;
import adams.gui.goe.GenericArrayEditor;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.IntegerEditor;
import adams.gui.goe.LongEditor;
import adams.gui.goe.ShortEditor;
import adams.gui.goe.StringEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;

public class Editors {
    public static final String FILENAME = "Editors.props";
    public static final String BLACKLIST = "Editors.blacklist";
    protected static Properties m_BlacklistedClasses;

    protected static Properties getAvailableEditors() {
        String classname;
        Properties result = new Properties();
        Properties classes = ClassLister.getSingleton().getClasses();
        String goeEditor = GenericObjectEditor.class.getName();
        String arrEditor = GenericArrayEditor.class.getName();
        String enmEditor = EnumEditor.class.getName();
        result.setProperty(Object.class.getName() + "[]", arrEditor);
        Enumeration<?> enm = classes.propertyNames();
        while (enm.hasMoreElements()) {
            classname = (String)enm.nextElement();
            result.setProperty(classname, goeEditor);
            result.setProperty(classname + "[]", arrEditor);
        }
        HashSet<String> uniquePackages = new HashSet<String>();
        Properties packages = ClassLister.getSingleton().getPackages();
        enm = packages.propertyNames();
        while (enm.hasMoreElements()) {
            classname = (String)enm.nextElement();
            String[] classnames = ClassLister.getSingleton().getPackages(classname);
            for (int i = 0; i < classnames.length; ++i) {
                uniquePackages.add(classnames[i]);
            }
        }
        for (String pkg : uniquePackages) {
            List<String> enums = ClassLocator.getSingleton().findInPackage(Enum.class, pkg);
            for (String cname : enums) {
                if (result.hasKey(cname)) continue;
                result.setProperty(cname, enmEditor);
                result.setProperty(cname + "[]", arrEditor);
            }
        }
        return result;
    }

    public static void registerEditors() {
        Properties props = Editors.getAvailableEditors();
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement().toString();
            String value = props.getProperty(name, "");
            try {
                Class<?> cls;
                if (name.endsWith("[]")) {
                    Class<?> baseCls = Class.forName(name.substring(0, name.indexOf("[]")));
                    cls = Array.newInstance(baseCls, 1).getClass();
                } else {
                    cls = Class.forName(name);
                }
                PropertyEditorManager.registerEditor(cls, Class.forName(value));
            }
            catch (Exception e) {
                System.err.println("Problem registering " + name + "/" + value + ": " + e);
            }
        }
        Editors.registerCustomEditors();
        Editors.registerBasicEditors();
    }

    protected static synchronized Properties getBlacklistedClasses() {
        if (m_BlacklistedClasses == null) {
            m_BlacklistedClasses = Environment.getInstance().read("goe blacklist");
        }
        return m_BlacklistedClasses;
    }

    public static boolean isBlacklisted(Class cls, boolean array) {
        if (array) {
            return Editors.getBlacklistedClasses().getBoolean(cls.getName(), false);
        }
        return Editors.getBlacklistedClasses().getBoolean(cls.getName() + "[]", false);
    }

    public static boolean isBlacklisted(Class cls, String property) {
        return Editors.getBlacklistedClasses().getBoolean(cls.getName() + "#" + property, false) != false || Editors.isBlacklisted(cls, false);
    }

    protected static void registerBasicEditors() {
        try {
            PropertyEditorManager.registerEditor(Byte.class, ByteEditor.class);
            PropertyEditorManager.registerEditor(Byte.TYPE, ByteEditor.class);
            PropertyEditorManager.registerEditor(Short.class, ShortEditor.class);
            PropertyEditorManager.registerEditor(Short.TYPE, ShortEditor.class);
            PropertyEditorManager.registerEditor(Integer.class, IntegerEditor.class);
            PropertyEditorManager.registerEditor(Integer.TYPE, IntegerEditor.class);
            PropertyEditorManager.registerEditor(Long.class, LongEditor.class);
            PropertyEditorManager.registerEditor(Long.TYPE, LongEditor.class);
            PropertyEditorManager.registerEditor(Float.class, FloatEditor.class);
            PropertyEditorManager.registerEditor(Float.TYPE, FloatEditor.class);
            PropertyEditorManager.registerEditor(Double.class, DoubleEditor.class);
            PropertyEditorManager.registerEditor(Double.TYPE, DoubleEditor.class);
            PropertyEditorManager.registerEditor(Boolean.class, BooleanEditor.class);
            PropertyEditorManager.registerEditor(Boolean.TYPE, BooleanEditor.class);
            PropertyEditorManager.registerEditor(String.class, StringEditor.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean registerCustomEditor(Class cls, Class clsEditor) {
        boolean result;
        try {
            PropertyEditorManager.registerEditor(cls, clsEditor);
            PropertyEditorManager.registerEditor(Array.newInstance(cls, 1).getClass(), GenericArrayEditor.class);
            result = true;
        }
        catch (Exception e) {
            result = false;
            System.err.println("Registering editor " + clsEditor.getName() + " for class " + cls.getName() + " failed:\n" + e);
            e.printStackTrace();
        }
        return result;
    }

    protected static Properties getCustomEditors() {
        return Environment.getInstance().read("goe editors");
    }

    protected static void registerCustomEditors() {
        Properties props = Editors.getCustomEditors();
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String classname = (String)enm.nextElement();
            if (classname.indexOf("#") > -1) continue;
            String classnameEditor = props.getProperty(classname);
            Class<?> cls = null;
            try {
                if (classname.endsWith("[]")) {
                    cls = Class.forName(classname.substring(0, classname.length() - 2));
                    cls = Array.newInstance(cls, 0).getClass();
                } else {
                    cls = Class.forName(classname);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Cannot get class for '" + classname + "' - skipped!");
                continue;
            }
            Class<?> clsEditor = null;
            try {
                clsEditor = Class.forName(classnameEditor);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Cannot get class for editor '" + classnameEditor + "' - skipped!");
                continue;
            }
            Editors.registerCustomEditor(cls, clsEditor);
        }
    }
}

