/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.gui.print.ScalableComponentWriter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public abstract class BufferedImageBasedWriter
extends ScalableComponentWriter {
    private static final long serialVersionUID = 137689227628055443L;
    protected Color m_Background;
    protected Type m_Type;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("background", "background", Color.WHITE);
        this.m_OptionManager.add("type", "type", (Object)Type.RGB);
    }

    public void setBackground(Color value) {
        this.m_Background = value;
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The background color.";
    }

    public void setType(Type value) {
        this.m_Type = value;
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of image to create.";
    }

    protected BufferedImage createBufferedImage() {
        BufferedImage result;
        if (this.m_Type == Type.RGB) {
            result = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        } else if (this.m_Type == Type.GRAY) {
            result = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 10);
        } else {
            throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
        }
        Graphics g = result.getGraphics();
        g.setPaintMode();
        g.setColor(this.getBackground());
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(this.getXScale(), this.getYScale());
        }
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().printAll(g);
        return result;
    }

    public static enum Type {
        RGB,
        GRAY;

    }
}

