/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.db.DatabaseConnectionHandler;
import adams.gui.scripting.AbstractDataContainerUpdatingScriptlet;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.VisibilityContainerManager;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFilterScriptlet
extends AbstractDataContainerUpdatingScriptlet {
    private static final long serialVersionUID = -9200477598539423747L;

    @Override
    protected String getOptionsDescription() {
        return "<classname + options>";
    }

    public String process(String options, boolean overlay) throws Exception {
        int i;
        Object manager = this.getDataContainerPanel().getContainerManager();
        if (((VisibilityContainerManager)manager).countVisible() == 0) {
            return "No visible containers!";
        }
        ArrayList<DataContainer> runInput = new ArrayList<DataContainer>();
        for (i = 0; i < ((AbstractContainerManager)manager).count(); ++i) {
            if (!((VisibilityContainerManager)manager).isVisible(i)) continue;
            runInput.add((DataContainer)((AbstractContainer)((AbstractContainerManager)manager).get(i)).getPayload());
        }
        AbstractFilter runScheme = AbstractFilter.forCommandLine(options);
        if (runScheme instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)runScheme)).setDatabaseConnection(this.getOwner().getDatabaseConnection());
        }
        this.addUndoPoint("Saving undo data...", "Filter: " + runScheme.getClass().getName().replaceAll(".*\\.", ""));
        this.showStatus("Filtering...");
        List<DataContainer> runOutput = AbstractFilter.filter(runScheme.shallowCopy(true), runInput);
        ArrayList<DataContainer> runOutputC = new ArrayList<DataContainer>();
        for (i = 0; i < runOutput.size(); ++i) {
            runOutputC.add(runOutput.get(i));
        }
        this.updateDataContainers(runOutputC, overlay);
        runScheme.destroy();
        this.showStatus("");
        return null;
    }
}

