/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.io.input.AbstractDataContainerReader;
import adams.gui.scripting.AbstractDataContainerPanelScriptlet;
import adams.gui.visualization.container.AbstractContainerManager;
import java.util.ArrayList;
import java.util.List;

public class AddDataFiles
extends AbstractDataContainerPanelScriptlet {
    private static final long serialVersionUID = -3048379013750352301L;
    public static final String ACTION = "add-data-files";

    @Override
    public String getAction() {
        return ACTION;
    }

    @Override
    protected String getOptionsDescription() {
        return "\"<datacontainer-reader scheme>\" \"<file1>\" \"<file2>\" ...";
    }

    @Override
    public String getDescription() {
        return "Adds the data containers loaded from files via the given reader to the currently loaded ones.";
    }

    @Override
    public String process(String options) throws Exception {
        String result = null;
        String[] opts = OptionUtils.splitOptions(options);
        if (opts.length < 2) {
            throw new IllegalArgumentException("At least data container reader commandline and one file is expected, provided: " + options);
        }
        AbstractDataContainerReader reader = AbstractDataContainerReader.forCommandLine(opts[0]);
        this.addUndoPoint("Saving undo data...", "Loading data with: " + OptionUtils.getCommandLine(reader));
        Object manager = this.getDataContainerPanel().getContainerManager();
        ((AbstractContainerManager)manager).startUpdate();
        for (int n = 1; n < opts.length; ++n) {
            List<Object> data;
            String msg = null;
            this.showStatus("Loading (" + n + "/" + opts.length + "): " + opts[n]);
            try {
                reader.setInput(new PlaceholderFile(opts[n]));
                data = reader.read();
            }
            catch (Exception e) {
                data = new ArrayList();
                msg = "Error reading data from '" + opts[n] + "': " + Utils.throwableToString(e);
                this.getLogger().severe(result);
            }
            if (msg == null) {
                for (int i = 0; i < data.size(); ++i) {
                    ((AbstractContainerManager)manager).add(((AbstractContainerManager)manager).newContainer((Comparable)data.get(i)));
                }
            }
            if (msg == null) continue;
            result = result == null ? msg : result + "\n" + msg;
        }
        this.showStatus("");
        ((AbstractContainerManager)manager).finishUpdate();
        return result;
    }
}

