/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.data.id.IDHandler;
import adams.data.io.output.SpreadSheetWriter;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextAreaWithButtons;
import adams.gui.core.BaseTextPaneWithWordWrap;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanelWithButtons;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SortableAndSearchableTableWithButtons;
import adams.gui.event.PopupMenuListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.tools.AbstractManagementTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Array;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public abstract class AbstractManagementPanel<T extends Comparable>
extends BasePanel
implements CleanUpHandler {
    private static final long serialVersionUID = 3181901882660335578L;
    protected JButton m_ButtonClear;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonUpdate;
    protected SortableAndSearchableTableWithButtons m_TableValues;
    protected AbstractManagementTableModel<T> m_ModelValues;
    protected JButton m_ButtonRefresh;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonLoad;
    protected ParameterPanelWithButtons m_PanelValues;
    protected JPanel m_PanelTable;
    protected SearchPanel m_PanelSearch;
    protected SpreadSheetFileChooser m_FileChooser;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelValues = new ParameterPanelWithButtons();
        this.m_PanelValues.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addFields(this.m_PanelValues);
        this.add((Component)this.m_PanelValues, "North");
        this.m_ButtonClear = new JButton("Clear");
        this.m_ButtonClear.setMnemonic('C');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractManagementPanel.this.clear();
            }
        });
        this.m_PanelValues.addToButtonsPanel(this.m_ButtonClear);
        if (!this.isReadOnly()) {
            this.m_ButtonAdd = new JButton("Add");
            this.m_ButtonAdd.setMnemonic('A');
            this.m_ButtonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractManagementPanel.this.addObject();
                }
            });
            this.m_PanelValues.addToButtonsPanel(this.m_ButtonAdd);
        }
        if (!this.isReadOnly()) {
            this.m_ButtonUpdate = new JButton("Update");
            this.m_ButtonUpdate.setMnemonic('U');
            this.m_ButtonUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractManagementPanel.this.updateObject();
                }
            });
            this.m_PanelValues.addToButtonsPanel(this.m_ButtonUpdate);
        }
        this.m_PanelTable = new JPanel(new BorderLayout());
        this.m_PanelTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.m_PanelTable, "Center");
        this.m_ModelValues = this.newTableModel();
        this.m_TableValues = new SortableAndSearchableTableWithButtons(this.m_ModelValues);
        this.m_TableValues.setAutoResizeMode(0);
        this.m_TableValues.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractManagementPanel.this.update();
            }
        });
        this.m_TableValues.addCellPopupMenuListener(new PopupMenuListener(){

            @Override
            public void showPopupMenu(MouseEvent e) {
                JPopupMenu menu = AbstractManagementPanel.this.createPopupMenu(e);
                if (menu != null) {
                    menu.show((Component)AbstractManagementPanel.this.m_TableValues.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.m_PanelTable.add((Component)this.m_TableValues, "Center");
        this.m_ButtonRefresh = new JButton("Refresh");
        this.m_ButtonRefresh.setMnemonic('R');
        this.m_ButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractManagementPanel.this.refresh();
            }
        });
        this.m_TableValues.addToButtonsPanel(this.m_ButtonRefresh);
        this.m_ButtonLoad = new JButton("Load");
        this.m_ButtonLoad.setMnemonic('L');
        this.m_ButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractManagementPanel.this.loadValue();
            }
        });
        this.m_TableValues.addToButtonsPanel(this.m_ButtonLoad);
        this.m_TableValues.setDoubleClickButton(this.m_ButtonLoad);
        this.m_TableValues.addToButtonsPanel(new JLabel(" "));
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.setMnemonic('m');
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractManagementPanel.this.removeObjects();
            }
        });
        this.m_TableValues.addToButtonsPanel(this.m_ButtonRemove);
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                AbstractManagementPanel.this.m_TableValues.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        this.add((Component)this.m_PanelSearch, "South");
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.clear();
        this.refresh();
    }

    protected synchronized SpreadSheetFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
            this.m_FileChooser.setMultiSelectionEnabled(false);
        }
        return this.m_FileChooser;
    }

    protected JPopupMenu createPopupMenu(MouseEvent e) {
        JPopupMenu result = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.m_TableValues.getSelectedRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SortableAndSearchableTable)AbstractManagementPanel.this.m_TableValues.getComponent()).copyToClipboard();
            }
        });
        result.add(menuitem);
        menuitem = new JMenuItem("Save as...");
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret = AbstractManagementPanel.this.getFileChooser().showSaveDialog(AbstractManagementPanel.this);
                if (ret != 0) {
                    return;
                }
                File file = AbstractManagementPanel.this.getFileChooser().getSelectedFile();
                SpreadSheetWriter writer = (SpreadSheetWriter)AbstractManagementPanel.this.getFileChooser().getWriter();
                if (!writer.write(AbstractManagementPanel.this.m_ModelValues.toSpreadSheet(), file)) {
                    GUIHelper.showErrorMessage(AbstractManagementPanel.this, "Failed to save spreadsheet to the following file:\n" + file);
                }
            }
        });
        result.add(menuitem);
        return result;
    }

    protected void addDocumentListener(Document doc) {
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractManagementPanel.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractManagementPanel.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractManagementPanel.this.update();
            }
        });
    }

    protected void addActionListener(JComboBox combo) {
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractManagementPanel.this.update();
            }
        });
    }

    protected void addChangeListener(AbstractChooserPanel chooser) {
        chooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractManagementPanel.this.update();
            }
        });
    }

    protected void addListener(Component comp) {
        if (comp instanceof JTextField) {
            this.addDocumentListener(((JTextField)comp).getDocument());
        } else if (comp instanceof JTextArea) {
            this.addDocumentListener(((JTextArea)comp).getDocument());
        } else if (comp instanceof BaseTextAreaWithButtons) {
            this.addDocumentListener(((BaseTextAreaWithButtons)comp).getDocument());
        } else if (comp instanceof JTextPane) {
            this.addDocumentListener(((JTextPane)comp).getDocument());
        } else if (comp instanceof BaseTextPaneWithWordWrap) {
            this.addDocumentListener(((BaseTextPaneWithWordWrap)comp).getDocument());
        } else if (comp instanceof JComboBox) {
            this.addActionListener((JComboBox)comp);
        } else if (comp instanceof AbstractChooserPanel) {
            this.addChangeListener((AbstractChooserPanel)comp);
        }
    }

    protected abstract void addFields(ParameterPanelWithButtons var1);

    protected abstract AbstractManagementTableModel<T> newTableModel();

    protected abstract Class getManagedClass();

    protected String getItemName(boolean multiple) {
        String result = this.getManagedClass().getSimpleName();
        if (multiple) {
            result = result + "s";
        }
        return result;
    }

    protected abstract void clear();

    protected abstract T fieldsToObject();

    protected abstract void objectToFields(T var1);

    protected abstract List<T> loadAll();

    protected abstract boolean exists(T var1);

    protected abstract boolean store(T var1);

    protected abstract boolean remove(T var1);

    protected String getID(T value) {
        if (value instanceof IDHandler) {
            return ((IDHandler)value).getID();
        }
        return null;
    }

    protected void addObject() {
        T value = this.fieldsToObject();
        if (this.exists(value)) {
            GUIHelper.showErrorMessage(this, this.getItemName(false) + " with ID '" + this.getID(value) + "' already exists!");
            return;
        }
        if (!this.store(value)) {
            GUIHelper.showErrorMessage(this, "Couldn't add " + this.getItemName(false) + " with '" + this.getID(value) + "' - check console!");
        }
        this.refresh();
    }

    protected void updateObject() {
        T value = this.fieldsToObject();
        if (!this.exists(value)) {
            GUIHelper.showErrorMessage(this, this.getItemName(false) + " with ID '" + this.getID(value) + "' doesn't exists - cannot update, use 'Add'!");
            return;
        }
        if (!this.store(value)) {
            GUIHelper.showErrorMessage(this, "Couldn't update " + this.getItemName(false) + " with ID '" + this.getID(value) + "' - check console!");
        }
        this.refresh();
    }

    protected void removeObjects() {
        int[] indices = this.m_TableValues.getSelectedRows();
        Comparable[] values = (Comparable[])Array.newInstance(this.getManagedClass(), indices.length);
        String ids = "";
        for (int i = 0; i < indices.length; ++i) {
            values[i] = this.m_ModelValues.getItemAt(this.m_TableValues.getActualRow(indices[i]));
            if (i > 0) {
                ids = ids + ", ";
            }
            ids = ids + this.getID(values[i]);
        }
        int retVal = GUIHelper.showConfirmMessage(this, "Do you really want to remove the following " + this.getItemName(indices.length != 1) + "?", ids, "Confirm removal");
        if (retVal != 0) {
            return;
        }
        for (Comparable value : values) {
            this.remove(value);
        }
        this.refresh();
    }

    protected void loadValue() {
        int row = this.m_TableValues.getSelectedRow();
        if (row == -1) {
            return;
        }
        Object value = this.m_ModelValues.getItemAt(this.m_TableValues.getActualRow(row));
        this.objectToFields(value);
        this.update();
    }

    protected void refresh() {
        this.m_ModelValues.clear();
        this.m_ModelValues.addAll(this.loadAll());
        this.m_TableValues.setOptimalColumnWidth();
        this.update();
    }

    protected abstract boolean canClearFields();

    protected abstract boolean isReadOnly();

    protected abstract boolean canAddObject();

    protected void update() {
        this.m_ButtonClear.setEnabled(this.canClearFields());
        if (!this.isReadOnly()) {
            this.m_ButtonAdd.setEnabled(this.canAddObject());
            this.m_ButtonUpdate.setEnabled(this.m_ButtonAdd.isEnabled());
        }
        this.m_ButtonLoad.setEnabled(this.m_TableValues.getSelectedRowCount() == 1);
        this.m_ButtonRemove.setEnabled(this.m_TableValues.getSelectedRowCount() > 0);
    }

    @Override
    public void cleanUp() {
    }
}

