/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.visualization.container.AbstractContainer;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractContainerManager<T extends AbstractContainer>
implements Serializable {
    private static final long serialVersionUID = -2758522365930747099L;
    protected List<T> m_List = new ArrayList<T>();
    protected HashSet<DataChangeListener> m_DataChangeListeners = new HashSet();
    protected boolean m_AllowRemoval = true;
    protected boolean m_Updating = false;

    protected AbstractContainerManager() {
    }

    public void setAllowRemoval(boolean value) {
        this.m_AllowRemoval = value;
    }

    public boolean getAllowRemoval() {
        return this.m_AllowRemoval;
    }

    public void startUpdate() {
        this.m_Updating = true;
    }

    public void finishUpdate() {
        this.finishUpdate(true);
    }

    public void finishUpdate(boolean notify) {
        this.m_Updating = false;
        if (notify) {
            this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.BULK_UPDATE));
        }
    }

    public boolean isUpdating() {
        return this.m_Updating;
    }

    public void clear() {
        this.m_List.clear();
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.CLEAR));
    }

    public abstract T newContainer(Comparable var1);

    public boolean contains(T o) {
        boolean result = false;
        for (int i = 0; i < this.m_List.size(); ++i) {
            if (!((AbstractContainer)this.m_List.get(i)).equals(o)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected T preAdd(T c) {
        return c;
    }

    public void add(T c) {
        ((AbstractContainer)c).setManager(this);
        c = this.preAdd(c);
        this.m_List.add(c);
        int index = this.indexOf(c);
        if (index > -1) {
            this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.ADDITION, index));
        }
        this.postAdd(c);
    }

    public void postAdd(T c) {
    }

    public void addAll(Collection<T> c) {
        this.startUpdate();
        TIntArrayList indices = new TIntArrayList();
        for (AbstractContainer cont : c) {
            this.add(cont);
            int index = this.indexOf(cont);
            if (index <= -1) continue;
            indices.add(index);
        }
        this.finishUpdate(false);
        if (indices.size() > 0) {
            this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.ADDITION, indices.toArray()));
        }
    }

    public T get(int index) {
        return (T)((AbstractContainer)this.m_List.get(index));
    }

    public List<T> getAll() {
        ArrayList<AbstractContainer> result = new ArrayList<AbstractContainer>();
        for (int i = 0; i < this.count(); ++i) {
            AbstractContainer cont = ((AbstractContainer)this.get(i)).copy();
            cont.setManager(null);
            result.add(cont);
        }
        return result;
    }

    protected T preSet(int index, T c) {
        return c;
    }

    public T set(int index, T c) {
        boolean localUpdating;
        boolean bl = localUpdating = !this.m_Updating;
        if (localUpdating) {
            this.m_Updating = true;
        }
        AbstractContainer result = (AbstractContainer)this.m_List.set(index, this.preSet(index, c));
        if (localUpdating) {
            this.m_Updating = false;
        }
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.REPLACEMENT, index, result));
        this.postSet(index, c, result);
        return (T)result;
    }

    protected void postSet(int index, T c, T old) {
    }

    public T remove(int index) {
        if (!this.m_AllowRemoval) {
            return null;
        }
        AbstractContainer result = (AbstractContainer)this.m_List.remove(index);
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.REMOVAL, index, result));
        return (T)result;
    }

    public int count() {
        return this.m_List.size();
    }

    public int indexOf(T c) {
        return this.m_List.indexOf(c);
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.m_DataChangeListeners.add(l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.m_DataChangeListeners.remove(l);
    }

    public void notifyDataChangeListeners(DataChangeEvent e) {
        if (this.isUpdating()) {
            return;
        }
        Iterator<DataChangeListener> iter = this.m_DataChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().dataChanged(e);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (int i = 0; i < this.count(); ++i) {
            result.append(((AbstractContainer)this.get(i)).toString());
        }
        result.append("]");
        return result.toString();
    }
}

