/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.core.Properties;
import adams.data.Notes;
import adams.data.NotesHandler;
import adams.data.id.DatabaseIDHandler;
import adams.data.report.ReportHandler;
import adams.env.Environment;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseMultiPagePane;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.scripting.SyntaxDocument;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.NamedContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.Document;

public class NotesFactory {
    public static TextPane getTextPane(AbstractContainer data) {
        return new TextPane<AbstractContainer>(data);
    }

    public static MultiPagePane getMultiPagePane(List<AbstractContainer> data) {
        return new MultiPagePane<AbstractContainer>(data);
    }

    public static Dialog getDialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
        return new Dialog(owner, modality);
    }

    public static Dialog getDialog(Frame owner, boolean modal) {
        return new Dialog(owner, modal);
    }

    public static class Dialog<T extends AbstractContainer>
    extends BaseDialog {
        private static final long serialVersionUID = 1739123906988587074L;
        public static final int DEFAULT_WIDTH = 600;
        public static final int MIN_HEIGHT = 200;
        protected Dialog m_Self;
        protected MultiPagePane m_MultiPagePane;

        public Dialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
            super(owner, modality);
        }

        public Dialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.m_Self = this;
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setTitle("Notes");
            this.getContentPane().setLayout(new BorderLayout());
            this.m_MultiPagePane = NotesFactory.getMultiPagePane(null);
            this.getContentPane().add((Component)this.m_MultiPagePane, "Center");
            JPanel panel = new JPanel(new FlowLayout(2));
            this.getContentPane().add((Component)panel, "South");
            JButton buttonOK = new JButton("OK");
            buttonOK.setMnemonic('O');
            buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    m_Self.setVisible(false);
                }
            });
            panel.add(buttonOK);
            this.adjustSize();
            this.setLocationRelativeTo(this.getOwner());
        }

        protected void adjustSize() {
            this.pack();
            int height = (int)this.getSize().getHeight();
            if (height < 200) {
                height = 200;
            }
            this.setSize(new Dimension(600, height));
        }

        public synchronized void setData(List<T> value) {
            this.m_MultiPagePane.setData(value);
            if (!this.isVisible()) {
                this.adjustSize();
                this.setLocationRelativeTo(this.getOwner());
                GUIHelper.setSizeAndLocation(this, this);
            }
        }

        public List<T> getData() {
            return this.m_MultiPagePane.getData();
        }
    }

    public static class MultiPagePane<T extends AbstractContainer>
    extends BaseMultiPagePane {
        private static final long serialVersionUID = -113778971321461204L;
        protected List<T> m_Data;

        public MultiPagePane() {
            this((List<T>)null);
        }

        public MultiPagePane(List<T> data) {
            this.setData(data);
        }

        public synchronized void setData(List<T> data) {
            this.m_Data = new ArrayList<T>();
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    this.m_Data.add(data.get(i));
                }
            }
            this.update();
        }

        public List<T> getData() {
            ArrayList<T> result = new ArrayList<T>();
            result.addAll(this.m_Data);
            return result;
        }

        protected synchronized void update() {
            this.removeAll();
            for (int i = 0; i < this.m_Data.size(); ++i) {
                String title;
                ReportHandler handler;
                if (!(((AbstractContainer)this.m_Data.get(i)).getPayload() instanceof ReportHandler) || !(handler = (ReportHandler)((Object)((AbstractContainer)this.m_Data.get(i)).getPayload())).hasReport()) continue;
                TextPane text = NotesFactory.getTextPane((AbstractContainer)this.m_Data.get(i));
                if (this.m_Data.get(i) instanceof NamedContainer) {
                    title = ((NamedContainer)this.m_Data.get(i)).getID();
                    if (((AbstractContainer)this.m_Data.get(i)).getPayload() instanceof DatabaseIDHandler) {
                        title = title + " (" + ((DatabaseIDHandler)((Object)((AbstractContainer)this.m_Data.get(i)).getPayload())).getDatabaseID() + ")";
                    }
                } else {
                    title = ((AbstractContainer)this.m_Data.get(i)).toString();
                }
                this.addPage(title, new BaseScrollPane(text));
            }
        }
    }

    public static class TextPane<T extends AbstractContainer>
    extends JTextPane {
        private static final long serialVersionUID = -1236250353157866097L;
        protected T m_Data;

        public TextPane() {
            this(null);
        }

        public TextPane(T data) {
            this.setDocument(this.createDocument());
            this.setEditable(false);
            this.setData(data);
        }

        protected Document createDocument() {
            Properties props = Environment.getInstance().read("scripting dialog");
            SyntaxDocument result = new SyntaxDocument(props);
            return result;
        }

        public void setData(T data) {
            this.m_Data = data;
            if (((AbstractContainer)this.m_Data).getPayload() instanceof NotesHandler) {
                Notes notes = ((NotesHandler)((Object)((AbstractContainer)this.m_Data).getPayload())).getNotes();
                StringBuilder buffer = new StringBuilder();
                Notes subnotes = notes.getErrors();
                buffer.append("Errors\n");
                if (subnotes.size() == 0) {
                    buffer.append("-none-");
                } else {
                    buffer.append(subnotes.toString());
                }
                buffer.append("\n");
                subnotes = notes.getWarnings();
                buffer.append("\n");
                buffer.append("Warnings\n");
                if (subnotes.size() == 0) {
                    buffer.append("-none-");
                } else {
                    buffer.append(subnotes.toString());
                }
                buffer.append("\n");
                subnotes = notes.getOthers();
                buffer.append("\n");
                buffer.append("Others\n");
                if (subnotes.size() == 0) {
                    buffer.append("-none-");
                } else {
                    buffer.append(subnotes.toString());
                }
                buffer.append("\n");
                subnotes = notes.getProcessInformation();
                buffer.append("\n");
                buffer.append("Process information\n");
                if (subnotes.size() == 0) {
                    buffer.append("-none-");
                } else {
                    buffer.append(subnotes.toString().replaceAll("PROCESS INFORMATION[^\n]*\n", ""));
                }
                buffer.append("\n");
                this.setText("");
                try {
                    this.getDocument().insertString(0, buffer.toString(), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.setText("");
            }
        }

        public T getData() {
            return this.m_Data;
        }

        @Override
        public void setSize(Dimension d) {
            if (d.width < this.getGraphicsConfiguration().getBounds().width) {
                d.width = this.getGraphicsConfiguration().getBounds().width;
            }
            super.setSize(d);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    }
}

