/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractTickGenerator;
import adams.gui.visualization.core.axis.FixedLabelTickGenerator;
import adams.gui.visualization.core.axis.Tick;
import java.util.ArrayList;
import java.util.List;

public class SimpleFixedLabelTickGenerator
extends AbstractTickGenerator
implements FixedLabelTickGenerator {
    private static final long serialVersionUID = -3950212023344727427L;
    protected List<String> m_FixedLabels;

    @Override
    public String globalInfo() {
        return "A simple tick generator that uses a fixed list of labels.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FixedLabels = new ArrayList<String>();
    }

    @Override
    public void setLabels(List<String> value) {
        this.m_FixedLabels = new ArrayList<String>(value);
    }

    @Override
    public List<String> getLabels() {
        return this.m_FixedLabels;
    }

    @Override
    protected void doGenerate() {
        double incValue = (this.m_Parent.getMaximum() - this.m_Parent.getMinimum()) / ((double)this.m_FixedLabels.size() - 1.0);
        if (Double.isNaN(incValue)) {
            return;
        }
        for (int i = 0; i < this.m_FixedLabels.size(); ++i) {
            double value = this.m_Parent.getMinimum() + (double)i * incValue;
            int pos = this.m_Parent.valueToPos(value);
            String label = this.m_FixedLabels.get(i);
            this.m_Ticks.add(new Tick(pos, label));
        }
    }

    @Override
    public String valueToDisplayLabel(double value) {
        int posAct;
        int posRound = this.m_Parent.valueToPos(Math.round(value));
        if (Math.abs(posRound - (posAct = this.m_Parent.valueToPos(value))) > 3) {
            return null;
        }
        double index = (int)(Math.round(value) - 1L);
        if (index >= 0.0 && index < (double)this.m_FixedLabels.size()) {
            return this.m_FixedLabels.get((int)index);
        }
        return null;
    }
}

