/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug;

import adams.core.ByteFormat;
import adams.core.SizeOf;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.SearchPanel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import adams.gui.visualization.debug.objecttree.Node;
import adams.gui.visualization.debug.objecttree.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class InspectionPanel
extends BasePanel {
    private static final long serialVersionUID = -3626608063857468806L;
    protected transient Object m_Object;
    protected Tree m_Tree;
    protected SearchPanel m_PanelSearch;
    protected BaseSplitPane m_SplitPane;
    protected BasePanel m_PanelContent;
    protected BasePanel m_PanelSize;
    protected JCheckBox m_CheckBoxSize;
    protected JTextField m_TextSize;
    protected String[] m_LastPath;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_LastPath = new String[0];
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.add((Component)this.m_SplitPane, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent(panel);
        this.m_SplitPane.setDividerLocation(450);
        this.m_Tree = new Tree();
        this.m_Tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (InspectionPanel.this.m_Tree.getSelectionPath() == null) {
                    return;
                }
                Node node = (Node)InspectionPanel.this.m_Tree.getSelectionPath().getLastPathComponent();
                InspectionPanel.this.m_PanelContent.removeAll();
                AbstractObjectRenderer.getRenderer(node.getUserObject()).get(0).render(node.getUserObject(), InspectionPanel.this.m_PanelContent);
                InspectionPanel.this.m_LastPath = node.getPropertyPath();
                InspectionPanel.this.updateSize(node.getUserObject());
            }
        });
        panel.add((Component)new BaseScrollPane(this.m_Tree), "Center");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                InspectionPanel.this.m_Tree.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        panel.add((Component)this.m_PanelSearch, "South");
        this.m_PanelContent = new BasePanel(new BorderLayout());
        this.m_PanelSize = new BasePanel(new FlowLayout(0));
        this.m_PanelSize.setVisible(SizeOf.isSizeOfAgentAvailable());
        this.m_PanelContent.add((Component)this.m_PanelSize, "South");
        this.m_CheckBoxSize = new JCheckBox("Size");
        this.m_CheckBoxSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InspectionPanel.this.m_Tree.getSelectionPath() == null) {
                    InspectionPanel.this.updateSize(null);
                } else {
                    InspectionPanel.this.updateSize(((Node)InspectionPanel.this.m_Tree.getSelectionPath().getLastPathComponent()).getUserObject());
                }
            }
        });
        this.m_PanelSize.add(this.m_CheckBoxSize);
        this.m_TextSize = new JTextField(10);
        this.m_TextSize.setEditable(false);
        this.m_PanelSize.add(this.m_TextSize);
        this.m_SplitPane.setRightComponent(this.m_PanelContent);
    }

    public synchronized void setCurrent(Object value) {
        this.m_Object = value;
        this.m_Tree.setObject(this.m_Object);
        this.m_PanelContent.removeAll();
        this.updateSize(null);
        if (this.m_LastPath.length > 0) {
            this.m_Tree.selectPropertyPath(this.m_LastPath);
        } else {
            this.m_Tree.setSelectionInterval(0, 0);
        }
    }

    public Object getCurrent() {
        return this.m_Object;
    }

    protected void updateSize(Object obj) {
        if (!this.m_PanelSize.isVisible()) {
            return;
        }
        if (this.m_CheckBoxSize.isSelected() && obj != null) {
            long size = SizeOf.sizeOf(obj);
            this.m_TextSize.setText(ByteFormat.toBestFitBytes(size, 1));
        } else {
            this.m_TextSize.setText("");
        }
    }
}

