/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.statistics;

import adams.data.statistics.InformativeStatistic;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseMultiPagePane;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTable;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class InformativeStatisticFactory {
    public static Model getModel(InformativeStatistic stat) {
        return new Model(stat);
    }

    public static Table getTable(InformativeStatistic stat) {
        return new Table(stat);
    }

    public static MultiPagePane getMultiPagePane(List<InformativeStatistic> stats) {
        return new MultiPagePane(stats);
    }

    public static Dialog getDialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
        return new Dialog(owner, modality);
    }

    public static Dialog getDialog(Frame owner, boolean modal) {
        return new Dialog(owner, modal);
    }

    public static class Dialog
    extends BaseDialog {
        private static final long serialVersionUID = 377068894443930941L;
        protected Dialog m_Self;
        protected MultiPagePane m_MultiPagePane;

        public Dialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
            super(owner, modality);
        }

        public Dialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.m_Self = this;
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setTitle("Statistics");
            this.getContentPane().setLayout(new BorderLayout());
            this.m_MultiPagePane = InformativeStatisticFactory.getMultiPagePane(null);
            this.getContentPane().add((Component)this.m_MultiPagePane, "Center");
            JPanel panel = new JPanel(new FlowLayout(2));
            this.getContentPane().add((Component)panel, "South");
            JButton buttonOK = new JButton("OK");
            buttonOK.setMnemonic('O');
            buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    m_Self.setVisible(false);
                }
            });
            panel.add(buttonOK);
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        public synchronized void setStatistics(List<InformativeStatistic> value) {
            this.m_MultiPagePane.setStatistics(value);
            if (!this.isVisible()) {
                this.pack();
                this.setLocationRelativeTo(this.getOwner());
                GUIHelper.setSizeAndLocation(this, this);
            }
        }

        public List<InformativeStatistic> getStatistics() {
            return this.m_MultiPagePane.getStatistics();
        }
    }

    public static class MultiPagePane
    extends BaseMultiPagePane {
        private static final long serialVersionUID = 3805619139057394474L;
        protected List<InformativeStatistic> m_Statistics;

        public MultiPagePane() {
            this((List<InformativeStatistic>)null);
        }

        public MultiPagePane(List<InformativeStatistic> stats) {
            this.setStatistics(stats);
        }

        public synchronized void setStatistics(List<InformativeStatistic> value) {
            this.m_Statistics = new ArrayList<InformativeStatistic>();
            if (value != null) {
                this.m_Statistics.addAll(value);
            }
            this.update();
        }

        public List<InformativeStatistic> getStatistics() {
            return this.m_Statistics;
        }

        protected void update() {
            this.removeAll();
            for (int i = 0; i < this.m_Statistics.size(); ++i) {
                Table table = InformativeStatisticFactory.getTable(this.m_Statistics.get(i));
                this.addPage(this.m_Statistics.get(i).getStatisticDescription(), new BaseScrollPane(table));
            }
        }
    }

    public static class Table
    extends BaseTable {
        private static final long serialVersionUID = 344016476619814279L;

        public Table(InformativeStatistic stat) {
            super(new Model(stat));
            this.setAutoResizeMode(0);
            this.setSelectionMode(0);
            this.setOptimalColumnWidth();
        }

        @Override
        public void setModel(TableModel model) {
            if (!(model instanceof Model)) {
                throw new IllegalArgumentException("Only models of type " + Model.class.getName() + " are allowed!");
            }
            super.setModel(model);
            this.setOptimalColumnWidth();
        }

        public void setStatistic(InformativeStatistic stat) {
            this.setModel(new Model(stat));
        }

        public InformativeStatistic getStatistic() {
            return ((Model)this.getModel()).getStatistic();
        }
    }

    public static class Model
    extends AbstractBaseTableModel {
        private static final long serialVersionUID = -248671609209397527L;
        protected InformativeStatistic m_Statistic;
        protected Object[][] m_Data;

        public Model(InformativeStatistic stat) {
            this.m_Statistic = stat;
            this.initialize();
        }

        protected void initialize() {
            ArrayList<String> names = new ArrayList<String>();
            Iterator<String> enm = this.m_Statistic.statisticNames();
            while (enm.hasNext()) {
                names.add(enm.next());
            }
            this.m_Data = new Object[names.size()][2];
            for (int i = 0; i < names.size(); ++i) {
                this.m_Data[i][0] = names.get(i);
                this.m_Data[i][1] = this.m_Statistic.getStatistic((String)names.get(i));
            }
        }

        public InformativeStatistic getStatistic() {
            return this.m_Statistic;
        }

        @Override
        public int getRowCount() {
            return this.m_Data.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            String result = null;
            if (column == 0) {
                result = "Statistic";
            } else if (column == 1) {
                result = "Value";
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.m_Data[row][column];
        }

        public Class getColumnClass(int column) {
            Class result = String.class;
            if (column == 0) {
                result = String.class;
            } else if (column == 1) {
                result = Double.class;
            }
            return result;
        }
    }
}

