/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseListWithButtons;
import adams.gui.wizard.AbstractWizardPage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class SelectMultipleFilesPage
extends AbstractWizardPage {
    private static final long serialVersionUID = -7633802524155866313L;
    public static final String KEY_FILES = "files";
    protected BaseListWithButtons m_ListFiles;
    protected BaseFileChooser m_FileChooser;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected JButton m_ButtonMoveUp;
    protected JButton m_ButtonMoveDown;

    public SelectMultipleFilesPage() {
    }

    public SelectMultipleFilesPage(String pageName) {
        this();
        this.setPageName(pageName);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_FileChooser.setAutoAppendExtension(true);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_ListFiles = new BaseListWithButtons(new DefaultListModel());
        this.m_ListFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectMultipleFilesPage.this.updateListButtons();
            }
        });
        this.add((Component)this.m_ListFiles, "Center");
        this.m_ButtonAdd = new JButton("Add...");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = SelectMultipleFilesPage.this.m_FileChooser.showOpenDialog(SelectMultipleFilesPage.this);
                if (retVal != 0) {
                    return;
                }
                File[] selected = SelectMultipleFilesPage.this.m_FileChooser.getSelectedFiles();
                DefaultListModel model = (DefaultListModel)SelectMultipleFilesPage.this.m_ListFiles.getModel();
                for (File file : selected) {
                    model.addElement(file.getAbsolutePath());
                }
                SelectMultipleFilesPage.this.updateListButtons();
            }
        });
        this.m_ListFiles.addToButtonsPanel(this.m_ButtonAdd);
        this.m_ListFiles.addToButtonsPanel(new JLabel(""));
        this.m_ButtonMoveUp = new JButton("Up");
        this.m_ButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectMultipleFilesPage.this.m_ListFiles.moveUp();
            }
        });
        this.m_ListFiles.addToButtonsPanel(this.m_ButtonMoveUp);
        this.m_ButtonMoveDown = new JButton("Down");
        this.m_ButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectMultipleFilesPage.this.m_ListFiles.moveDown();
            }
        });
        this.m_ListFiles.addToButtonsPanel(this.m_ButtonMoveDown);
        this.m_ListFiles.addToButtonsPanel(new JLabel(""));
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = SelectMultipleFilesPage.this.m_ListFiles.getSelectedIndices();
                DefaultListModel model = (DefaultListModel)SelectMultipleFilesPage.this.m_ListFiles.getModel();
                for (int i = indices.length - 1; i >= 0; --i) {
                    model.remove(indices[i]);
                }
                SelectMultipleFilesPage.this.updateListButtons();
            }
        });
        this.m_ListFiles.addToButtonsPanel(this.m_ButtonRemove);
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)SelectMultipleFilesPage.this.m_ListFiles.getModel();
                model.removeAllElements();
                SelectMultipleFilesPage.this.updateListButtons();
            }
        });
        this.m_ListFiles.addToButtonsPanel(this.m_ButtonRemoveAll);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateListButtons();
    }

    protected void updateListButtons() {
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonMoveUp.setEnabled(this.m_ListFiles.canMoveUp());
        this.m_ButtonMoveDown.setEnabled(this.m_ListFiles.canMoveDown());
        this.m_ButtonRemove.setEnabled(this.m_ListFiles.getSelectedIndices().length > 0);
        this.m_ButtonRemoveAll.setEnabled(this.m_ListFiles.getModel().getSize() > 0);
        this.updateButtons();
    }

    public void setAutoAppendExtension(boolean value) {
        this.m_FileChooser.setAutoAppendExtension(value);
    }

    public boolean getAutoAppendExtension() {
        return this.m_FileChooser.getAutoAppendExtension();
    }

    public void setDefaultExtension(String value) {
        this.m_FileChooser.setDefaultExtension(value);
    }

    public String getDefaultExtension() {
        return this.m_FileChooser.getDefaultExtension();
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(new PlaceholderFile(value));
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    public void setCurrent(File[] value) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (File file : value) {
            model.addElement(file.getAbsolutePath());
        }
        this.m_ListFiles.setModel(model);
    }

    public File[] getCurrent() {
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < this.m_ListFiles.getModel().getSize(); ++i) {
            result.add(new File("" + this.m_ListFiles.getModel().getElementAt(i)));
        }
        return result.toArray(new File[result.size()]);
    }

    public void addChoosableFileFilter(FileFilter value) {
        this.m_FileChooser.addChoosableFileFilter(value);
    }

    public void setFileFilter(FileFilter value) {
        this.m_FileChooser.setFileFilter(value);
    }

    public FileFilter getFileFilter() {
        return this.m_FileChooser.getFileFilter();
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < this.m_ListFiles.getModel().getSize(); ++i) {
            files.add("" + this.m_ListFiles.getModel().getElementAt(i));
        }
        result.setProperty(KEY_FILES, OptionUtils.joinOptions(files.toArray(new String[files.size()])));
        return result;
    }
}

