/*
 * Decompiled with CFR 0.152.
 */
package adams.multiprocess;

import adams.core.Pausable;
import adams.core.Performance;
import adams.core.management.ProcessUtils;
import adams.event.JobCompleteEvent;
import adams.event.JobCompleteListener;
import adams.multiprocess.Job;
import adams.multiprocess.JobCompleteManager;
import adams.multiprocess.JobList;
import adams.multiprocess.JobResult;
import adams.multiprocess.PausableFixedThreadPoolExecutor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class JobRunner<T extends Job>
implements Pausable {
    protected int m_NumThreads;
    protected HashSet<JobCompleteListener> m_JobCompleteListeners;
    protected Vector<T> m_queue = new Vector();
    protected PausableFixedThreadPoolExecutor m_Executor;

    public JobRunner() {
        this(-1);
    }

    public JobRunner(int numThreads) {
        this.m_JobCompleteListeners = new HashSet();
        this.m_NumThreads = numThreads;
        if (this.m_NumThreads < 1) {
            this.m_NumThreads = Performance.getMaxNumProcessors();
        }
        if (this.m_NumThreads < 1 || this.m_NumThreads > ProcessUtils.getAvailableProcessors()) {
            this.m_NumThreads = ProcessUtils.getAvailableProcessors();
        }
        this.addJobCompleteListener(JobCompleteManager.getSingleton());
    }

    public int getNumThreads() {
        return this.m_NumThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobCompleteListener(JobCompleteListener l) {
        HashSet<JobCompleteListener> hashSet = this.m_JobCompleteListeners;
        synchronized (hashSet) {
            this.m_JobCompleteListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobCompleteListener(JobCompleteListener l) {
        HashSet<JobCompleteListener> hashSet = this.m_JobCompleteListeners;
        synchronized (hashSet) {
            this.m_JobCompleteListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyJobCompleteListeners(JobCompleteEvent e) {
        HashSet<JobCompleteListener> hashSet = this.m_JobCompleteListeners;
        synchronized (hashSet) {
            Iterator<JobCompleteListener> iter = this.m_JobCompleteListeners.iterator();
            while (iter.hasNext()) {
                iter.next().jobCompleted(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T job) {
        Vector<T> vector = this.m_queue;
        synchronized (vector) {
            this.m_queue.add(job);
        }
        this.enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(JobList<T> jobs) {
        Vector<T> vector = this.m_queue;
        synchronized (vector) {
            this.m_queue.addAll(jobs);
        }
        this.enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean enqueue() {
        boolean result = false;
        if (this.m_Executor == null) {
            return result;
        }
        if (this.m_queue.size() > 0) {
            Vector<T> vector = this.m_queue;
            synchronized (vector) {
                Vector<Job> queue = new Vector<Job>();
                for (final Job j : this.m_queue) {
                    queue.add(j);
                    Callable<String> job = new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            JobResult jr = j.execute();
                            JobRunner.this.complete(j, jr);
                            String result = null;
                            if (!jr.getSuccess()) {
                                result = jr.toString();
                            }
                            return result;
                        }
                    };
                    try {
                        this.m_Executor.submit(job);
                    }
                    catch (Exception exception) {}
                }
                this.m_queue.removeAll(queue);
            }
            result = true;
        }
        return result;
    }

    public void start() {
        if (this.m_Executor == null) {
            this.m_Executor = new PausableFixedThreadPoolExecutor(this.m_NumThreads);
        }
        this.enqueue();
    }

    public void stop() {
        if (this.m_Executor == null) {
            return;
        }
        try {
            if (this.m_Executor.isPaused()) {
                this.m_Executor.resumeExecution();
            }
            this.m_Executor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.waitForComplete();
    }

    public void terminate() {
        if (this.m_Executor == null) {
            return;
        }
        try {
            if (this.m_Executor.isPaused()) {
                this.m_Executor.resumeExecution();
            }
            this.m_Executor.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.waitForComplete();
    }

    protected void waitForComplete() {
        while (this.m_Executor != null && !this.m_Executor.isTerminated()) {
            try {
                this.m_Executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {}
        }
        this.m_Executor = null;
    }

    public void complete(T j, JobResult jr) {
        this.notifyJobCompleteListeners(new JobCompleteEvent(this, (Job)j, jr));
        if (((Job)j).getJobCompleteListener() != null) {
            ((Job)j).getJobCompleteListener().jobCompleted(new JobCompleteEvent(this, (Job)j, jr));
        }
        this.enqueue();
    }

    @Override
    public void pauseExecution() {
        if (this.m_Executor != null) {
            this.m_Executor.pauseExecution();
        }
    }

    @Override
    public boolean isPaused() {
        if (this.m_Executor != null) {
            return this.m_Executor.isPaused();
        }
        return false;
    }

    @Override
    public void resumeExecution() {
        if (this.m_Executor != null) {
            this.m_Executor.resumeExecution();
        }
    }
}

