/*
 * Decompiled with CFR 0.152.
 */
package adams.run;

import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingObject;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.env.Environment;

public abstract class RunScheme
extends LoggingObject
implements OptionHandler {
    private static final long serialVersionUID = 7050643013286875370L;
    protected OptionManager m_OptionManager;

    public RunScheme() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
    }

    protected void initialize() {
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    @Override
    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
    }

    @Override
    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    @Override
    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    @Override
    public void destroy() {
        this.cleanUpOptions();
    }

    protected void preRun() throws Exception {
    }

    protected abstract void doRun() throws Exception;

    protected void postRun() throws Exception {
    }

    public void run() throws Exception {
        this.getLogger().info("\n--> Pre-run");
        this.preRun();
        this.getLogger().info("\n--> Run");
        this.doRun();
        this.getLogger().info("\n--> Post-run");
        this.postRun();
    }

    public static RunScheme forName(String classname, String[] options) {
        RunScheme result;
        try {
            result = (RunScheme)OptionUtils.forName(RunScheme.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static RunScheme forCommandLine(String cmdline) {
        return (RunScheme)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static void runScheme(Class env, Class scheme, String[] args) {
        Environment.setEnvironmentClass(env);
        LoggingHelper.useHandlerFromOptions(args);
        try {
            if (OptionUtils.helpRequested(args)) {
                System.out.println("Help requested...\n");
                RunScheme schemeInst = RunScheme.forName(scheme.getName(), new String[0]);
                System.out.print("\n" + OptionUtils.list(schemeInst));
                LoggingHelper.outputHandlerOption();
            } else {
                RunScheme schemeInst = RunScheme.forName(scheme.getName(), args);
                schemeInst.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

