/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.base.BaseDate;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseTime;
import adams.data.DateFormatString;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.report.AbstractField;
import adams.data.report.Field;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.Date;

public class TimeseriesShiftTimestamps
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 2616498525816421178L;
    protected TimestampSource m_Source;
    protected Field m_ReportField;
    protected String m_CustomFormat;
    protected BaseDateTime m_SuppliedTimestamp;
    protected BaseDateTime m_NewTimestamp;

    public String globalInfo() {
        return "Shifts the timestamps of the timeseries by a calculated amount.\nThe amount is either the difference between the 'new' timestamp and a timestamp from the report or a supplied timestamp.\nAccepted date formats (unless custom format specified):\nyyyy-MM-dd HH:mm:ss\nyyyy-MM-dd HH:mm:ss.S\nyyyy-MM-dd";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("source", "source", (Object)TimestampSource.SUPPLIED_TIMESTAMP);
        this.m_OptionManager.add("report-field", "reportField", (Object)new Field());
        this.m_OptionManager.add("custom-format", "customFormat", (Object)"");
        this.m_OptionManager.add("supplied-timestamp", "suppliedTimestamp", (Object)new BaseDateTime("NOW"));
        this.m_OptionManager.add("new-timestamp", "newTimestamp", (Object)new BaseDateTime("NOW"));
    }

    public void setSource(TimestampSource value) {
        this.m_Source = value;
        this.reset();
    }

    public TimestampSource getSource() {
        return this.m_Source;
    }

    public String sourceTipText() {
        return "Specifies where to get the 'old' timestamp from.";
    }

    public void setReportField(Field value) {
        this.m_ReportField = value;
        this.reset();
    }

    public Field getReportField() {
        return this.m_ReportField;
    }

    public String reportFieldTipText() {
        return "The report field to obtain the timestamp from.";
    }

    public void setCustomFormat(String value) {
        DateFormatString format = new DateFormatString();
        if (value.isEmpty() || format.isValid(value)) {
            this.m_CustomFormat = value;
            this.reset();
        } else {
            this.getLogger().warning("Invalid date format: " + value);
        }
    }

    public String getCustomFormat() {
        return this.m_CustomFormat;
    }

    public String customFormatTipText() {
        return "The custom date format to use for parsing the value from the report.";
    }

    public void setSuppliedTimestamp(BaseDateTime value) {
        this.m_SuppliedTimestamp = value;
        this.reset();
    }

    public BaseDateTime getSuppliedTimestamp() {
        return this.m_SuppliedTimestamp;
    }

    public String suppliedTimestampTipText() {
        return "The supplied timestamp value to use.";
    }

    public void setNewTimestamp(BaseDateTime value) {
        this.m_NewTimestamp = value;
        this.reset();
    }

    public BaseDateTime getNewTimestamp() {
        return this.m_NewTimestamp;
    }

    public String newTimestampTipText() {
        return "The new timestamp value to use.";
    }

    protected Timeseries processData(Timeseries data) {
        BaseDateTime old;
        Timeseries result = data.getHeader();
        switch (this.m_Source) {
            case REPORT_FIELD: {
                if (!data.hasReport()) {
                    throw new IllegalStateException("No report available!");
                }
                if (!data.getReport().hasValue((AbstractField)this.m_ReportField)) {
                    throw new IllegalStateException("No report field '" + this.m_ReportField + "' not available!");
                }
                String oldStr = data.getReport().getStringValue((AbstractField)this.m_ReportField);
                if (oldStr.isEmpty()) {
                    throw new IllegalStateException("Empty timestamp stored in report field '" + this.m_ReportField + "'!");
                }
                if (this.m_CustomFormat.isEmpty()) {
                    if (DateUtils.checkDateTime((String)oldStr)) {
                        old = new BaseDateTime(oldStr);
                        break;
                    }
                    if (DateUtils.checkDate((String)oldStr)) {
                        old = new BaseDateTime(new BaseDate(oldStr).dateValue());
                        break;
                    }
                    if (DateUtils.checkTime((String)oldStr)) {
                        old = new BaseDateTime(new BaseTime(oldStr).dateValue());
                        break;
                    }
                    throw new IllegalStateException("Timestamp in report field '" + this.m_ReportField + "' not recognized: " + oldStr);
                }
                Date oldDate = new DateFormat(this.m_CustomFormat).parse(oldStr);
                if (oldDate == null) {
                    throw new IllegalStateException("Failed to parse report field '" + this.m_ReportField + "' using '" + this.m_CustomFormat + "':" + oldStr);
                }
                old = new BaseDateTime(oldDate);
                break;
            }
            case SUPPLIED_TIMESTAMP: {
                old = this.m_SuppliedTimestamp;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled source: " + (Object)((Object)this.m_Source));
            }
        }
        long diff = this.m_NewTimestamp.dateValue().getTime() - old.dateValue().getTime();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("difference to old ('" + old + "'): " + diff);
        }
        for (int i = 0; i < data.size(); ++i) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)data.toList().get(i));
            result.add((DataPoint)new TimeseriesPoint(new Date(point.getTimestamp().getTime() + diff), point.getValue()));
        }
        return result;
    }

    public static enum TimestampSource {
        REPORT_FIELD,
        SUPPLIED_TIMESTAMP;

    }
}

