/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instance;

import adams.core.Range;
import adams.data.Notes;
import adams.data.NotesHandler;
import adams.data.container.AbstractDataContainer;
import adams.data.container.DataContainer;
import adams.data.container.DataPointComparator;
import adams.data.instance.InstancePoint;
import adams.data.instance.InstancePointComparator;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.data.weka.ArffUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instances;

public class Instance
extends AbstractDataContainer<InstancePoint>
implements MutableReportHandler<Report>,
NotesHandler,
SpreadSheetSupporter {
    private static final long serialVersionUID = 8553741559715144356L;
    public static final String REPORT_DATASET = "Dataset-Name";
    public static final String REPORT_DB_ID = "DB-ID";
    public static final String REPORT_ID = "ID";
    public static final String REPORT_DISPLAY_ID = "Display-ID";
    public static final String REPORT_CLASS = "Class";
    public static final String REPORT_ROW = "Dataset-Row";
    public static final String REPORT_ADDITIONAL_PREFIX = "Attribute-";
    protected static DataPointComparator m_Comparator;
    protected Instances m_DatasetHeader;
    protected Report m_Report = this.newReport();
    protected Notes m_Notes = new Notes();

    public Instance() {
        if (m_Comparator == null) {
            m_Comparator = this.newComparator();
        }
        this.setID("");
    }

    public void setID(String value) {
        super.setID(value);
        this.m_Report.addParameter(REPORT_DISPLAY_ID, value);
    }

    public DataPointComparator<InstancePoint> newComparator() {
        return new InstancePointComparator();
    }

    public DataPointComparator<InstancePoint> getComparator() {
        return m_Comparator;
    }

    public InstancePoint newPoint() {
        return new InstancePoint();
    }

    protected Report newReport() {
        Report result = new Report();
        result.addField((AbstractField)new Field(REPORT_DATASET, DataType.STRING));
        result.addField((AbstractField)new Field(REPORT_DB_ID, DataType.NUMERIC));
        result.addField((AbstractField)new Field(REPORT_ID, DataType.STRING));
        result.addField((AbstractField)new Field(REPORT_DISPLAY_ID, DataType.STRING));
        result.addField((AbstractField)new Field(REPORT_CLASS, DataType.STRING));
        return result;
    }

    public void clear() {
        this.m_DatasetHeader = null;
        this.m_Report = this.newReport();
        super.clear();
    }

    public void assign(DataContainer<InstancePoint> other) {
        super.assign(other);
        this.m_DatasetHeader = ((Instance)other).getDatasetHeader();
        this.m_Report = ((Instance)other).getReport().getClone();
        this.m_Notes = ((Instance)other).getNotes().getClone();
    }

    public boolean hasDatasetHeader() {
        return this.m_DatasetHeader != null;
    }

    public Instances getDatasetHeader() {
        return this.m_DatasetHeader;
    }

    public void set(weka.core.Instance inst) {
        this.set(inst, -1, new int[0], new Range("first-last"), null);
    }

    public void set(weka.core.Instance inst, int index, int[] additional, Range range, HashSet<Integer> attTypes) {
        int i;
        this.clear();
        this.m_DatasetHeader = new Instances(inst.dataset(), 0);
        range.setMax(inst.numAttributes());
        ArrayList<InstancePoint> list = new ArrayList<InstancePoint>();
        for (i = 0; i < inst.numAttributes(); ++i) {
            if (i == inst.classIndex() || !range.isInRange(i) || attTypes != null && !attTypes.contains(inst.attribute(i).type())) continue;
            list.add(new InstancePoint(i, inst.value(i)));
        }
        this.addAll(list);
        this.m_Report.addParameter(REPORT_DATASET, this.m_DatasetHeader.relationName());
        Attribute att = this.m_DatasetHeader.attribute(ArffUtils.getDBIDName());
        if (att != null) {
            this.m_Report.addParameter(REPORT_DB_ID, (Object)new Double(inst.value(att)));
            this.m_Report.setDatabaseID((int)inst.value(att));
        }
        if ((att = this.m_DatasetHeader.attribute(ArffUtils.getIDName())) != null) {
            this.m_Report.addParameter(REPORT_ID, (Object)new Double(inst.value(att)));
        }
        if (inst.classIndex() > -1) {
            if (inst.classAttribute().isNumeric()) {
                this.m_Report.addField((AbstractField)new Field(REPORT_CLASS, DataType.NUMERIC));
                if (inst.classIsMissing()) {
                    this.m_Report.addField((AbstractField)new Field(REPORT_CLASS, DataType.STRING));
                    this.m_Report.addParameter(REPORT_CLASS, "?");
                } else {
                    this.m_Report.addField((AbstractField)new Field(REPORT_CLASS, DataType.NUMERIC));
                    this.m_Report.addParameter(REPORT_CLASS, Double.toString(inst.classValue()));
                }
            } else {
                this.m_Report.addField((AbstractField)new Field(REPORT_CLASS, DataType.STRING));
                if (inst.classIsMissing()) {
                    this.m_Report.addParameter(REPORT_CLASS, "?");
                } else {
                    this.m_Report.addParameter(REPORT_CLASS, inst.stringValue(inst.classIndex()));
                }
            }
        }
        if (index != -1) {
            this.m_Report.addField((AbstractField)new Field(REPORT_ROW, DataType.NUMERIC));
            this.m_Report.addParameter(REPORT_ROW, (Object)new Double(index + 1));
        }
        for (i = 0; i < additional.length; ++i) {
            att = inst.attribute(additional[i]);
            String fieldStr = REPORT_ADDITIONAL_PREFIX + (additional[i] + 1) + "-" + att.name();
            if (att.isNumeric()) {
                this.m_Report.addField((AbstractField)new Field(fieldStr, DataType.NUMERIC));
                this.m_Report.addParameter(fieldStr, (Object)inst.value(additional[i]));
                continue;
            }
            this.m_Report.addField((AbstractField)new Field(fieldStr, DataType.STRING));
            this.m_Report.addParameter(fieldStr, inst.stringValue(additional[i]));
        }
        if (this.getID().length() == 0) {
            this.setID("" + inst.toString().hashCode());
        }
    }

    public boolean hasReport() {
        return true;
    }

    public void setReport(Report value) {
        this.m_Report = value;
    }

    public Report getReport() {
        return this.m_Report;
    }

    public weka.core.Instance toInstance() {
        DenseInstance result = null;
        if (this.hasDatasetHeader()) {
            result = new DenseInstance(this.m_DatasetHeader.numAttributes());
            result.setDataset(this.m_DatasetHeader);
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                InstancePoint point = (InstancePoint)((Object)iterator.next());
                if (point.getX() >= this.m_DatasetHeader.numAttributes()) continue;
                result.setValue(point.getX().intValue(), point.getY().doubleValue());
            }
            if (this.m_DatasetHeader.classIndex() > -1) {
                Field field = new Field(REPORT_CLASS, DataType.UNKNOWN);
                if (this.m_DatasetHeader.classAttribute().isNumeric()) {
                    result.setClassValue(this.getReport().getDoubleValue((AbstractField)field).doubleValue());
                } else {
                    result.setClassValue((double)this.m_DatasetHeader.classAttribute().indexOfValue(this.getReport().getStringValue((AbstractField)field)));
                }
            }
        }
        return result;
    }

    public Notes getNotes() {
        return this.m_Notes;
    }

    public SpreadSheet toSpreadSheet() {
        SpreadSheet result = new SpreadSheet();
        result.setName(this.getID());
        HeaderRow row = result.getHeaderRow();
        row.addCell("A").setContent("Attribute");
        row.addCell("V").setContent("Value");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            InstancePoint point = (InstancePoint)((Object)iter.next());
            row = result.addRow();
            row.addCell("A").setContent(point.getX());
            row.addCell("V").setContent(point.getY());
        }
        return result;
    }
}

