/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.predictions;

import adams.data.weka.predictions.AbstractErrorScaler;
import java.util.ArrayList;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;

public class NumericErrorScalerWithReference
extends AbstractErrorScaler {
    private static final long serialVersionUID = -8616657706467047751L;
    protected double m_ReferenceError;
    protected int m_ReferenceSize;

    public String globalInfo() {
        return "Scales the errors for numeric class attributes, using an user-specified error as reference point for a specified size.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reference-error", "referenceError", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("reference-size", "referenceSize", (Object)10, (Number)1, null);
    }

    public void setReferenceError(double value) {
        if (value > 0.0) {
            this.m_ReferenceError = value;
            this.reset();
        } else {
            this.getLogger().severe("Reference error must be greater than 0, provided: " + value);
        }
    }

    public double getReferenceError() {
        return this.m_ReferenceError;
    }

    public String referenceErrorTipText() {
        return "The absolute error to use as reference for the error sizes (> 0).";
    }

    public void setReferenceSize(int value) {
        if (value >= 1) {
            this.m_ReferenceSize = value;
            this.reset();
        } else {
            this.getLogger().severe("Reference size must be at least 1 pixel, provided: " + value);
        }
    }

    public int getReferenceSize() {
        return this.m_ReferenceSize;
    }

    public String referenceSizeTipText() {
        return "The size for the reference error (>= 1).";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        return result;
    }

    public ArrayList scale(ArrayList data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < data.size(); ++i) {
            Double errd = (Double)data.get(i);
            if (errd == null) continue;
            double err = Math.abs(errd);
            double temp = err / this.m_ReferenceError * (double)this.m_ReferenceSize;
            result.add(new Integer((int)temp));
        }
        return result;
    }
}

