/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.MutableActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaClassifier;
import adams.flow.transformer.WekaTrainClassifier;
import java.util.List;

public class FixDeprecatedWekaClassifier
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = -4170658262349662939L;

    public String globalInfo() {
        return "Replaces the WekaClassifier transformer with WekaClassifierSetup and WekaTrainClassifier instances";
    }

    protected void processActor(AbstractActor actor) {
        List classifiers = ActorUtils.enumerate((AbstractActor)actor, (Class[])new Class[]{WekaClassifier.class});
        for (AbstractActor classifier : classifiers) {
            WekaClassifier cactor = (WekaClassifier)classifier;
            String var = cactor.getOptionManager().getVariableForProperty("classifier");
            if (cactor.getParent() instanceof CallableActors) {
                WekaClassifierSetup setup = new WekaClassifierSetup();
                setup.setClassifier(cactor.getClassifier());
                if (var != null) {
                    setup.getOptionManager().setVariableForProperty("classifier", var);
                }
                setup.setName(cactor.getName());
                ((MutableActorHandler)cactor.getParent()).set(cactor.index(), (AbstractActor)setup);
                this.m_Modified = true;
                continue;
            }
            CallableActors callable = CallableActorHelper.createCallableActors((AbstractActor)cactor, (boolean)true);
            WekaClassifierSetup setup = new WekaClassifierSetup();
            setup.setClassifier(cactor.getClassifier());
            if (var != null) {
                setup.getOptionManager().setVariableForProperty("classifier", var);
            }
            callable.add((AbstractActor)setup);
            WekaTrainClassifier train = new WekaTrainClassifier();
            train.setClassifier(new CallableActorReference(setup.getName()));
            train.setName(cactor.getName());
            ((MutableActorHandler)cactor.getParent()).set(cactor.index(), (AbstractActor)train);
            this.m_Modified = true;
        }
    }
}

