/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderFile;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.chooser.WekaFileChooser;
import java.awt.Component;
import java.io.File;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;

public class DatasetFileChooserPanel
extends FileChooserPanel {
    private static final long serialVersionUID = -8755020252465094120L;
    protected WekaFileChooser m_FileChooser;
    protected AbstractFileLoader m_Loader;
    protected AbstractFileSaver m_Saver;

    public DatasetFileChooserPanel() {
        this("");
    }

    public DatasetFileChooserPanel(String path) {
        this((File)new PlaceholderFile(path));
    }

    public DatasetFileChooserPanel(File path) {
        super(path);
        this.initializeConverters(path);
    }

    protected void initializeConverters(File path) {
        if (path.length() > 0L && path.isFile()) {
            try {
                this.m_Loader = ConverterUtils.getLoaderForFile((File)path.getAbsoluteFile());
                if (this.m_Loader != null) {
                    this.m_Loader.setFile(path.getAbsoluteFile());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_Saver = ConverterUtils.getSaverForFile((File)path.getAbsoluteFile());
        } else {
            this.m_Loader = null;
            this.m_Saver = null;
        }
    }

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new WekaFileChooser();
        this.m_Loader = null;
        this.m_Saver = null;
    }

    protected File doChoose() {
        this.m_FileChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        if (!this.m_UseSaveDialog) {
            if (this.m_FileChooser.showOpenDialog((Component)this.m_Self) == 0) {
                this.m_Loader = (AbstractFileLoader)this.m_FileChooser.getReader();
                this.m_Saver = null;
                return new PlaceholderFile(this.m_FileChooser.getSelectedFile());
            }
            return null;
        }
        if (this.m_FileChooser.showSaveDialog((Component)this.m_Self) == 0) {
            this.m_Loader = null;
            this.m_Saver = (AbstractFileSaver)this.m_FileChooser.getWriter();
            return new PlaceholderFile(this.m_FileChooser.getSelectedFile());
        }
        return null;
    }

    public AbstractFileLoader getLoader() {
        if (this.m_Loader != null) {
            try {
                this.m_Loader.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_Loader;
    }

    public AbstractFileSaver getSaver() {
        return this.m_Saver;
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(value.getAbsoluteFile());
    }

    public File getCurrentDirectory() {
        return new PlaceholderFile(this.m_FileChooser.getCurrentDirectory());
    }

    public boolean setCurrent(File value) {
        boolean result = super.setCurrent(value);
        this.initializeConverters((File)this.getCurrent());
        this.m_FileChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        return result;
    }
}

