/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionUtils;
import adams.data.DecimalFormatString;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.event.FitnessChangeEvent;
import adams.event.FitnessChangeListener;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.CirclePaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.WekaPropertySheetPanelPage;
import adams.gui.wizard.WizardPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class DarkLord
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = 7586443345167287461L;

    public DarkLord() {
        this(null);
    }

    public DarkLord(AbstractApplicationFrame owner) {
        super(owner);
    }

    public String getIconName() {
        return "genetic.png";
    }

    public void launch() {
        final WizardPane wizard = new WizardPane();
        wizard.setCustomFinishText("Execute");
        adams.genetic.DarkLord setup = new adams.genetic.DarkLord();
        setup.setLoggingLevel(LoggingLevel.FINE);
        setup.setNotificationInterval(10);
        WekaPropertySheetPanelPage algorithm = new WekaPropertySheetPanelPage("Setup");
        algorithm.setButtonPanelVisible(true);
        algorithm.setTarget(setup);
        algorithm.setDescription("Configure the genetic algorithm setup.\nSelect the dataset that you want to have optimized and the classifier to use for optimizing.");
        algorithm.setPageCheck(new PageCheck(){

            public boolean checkPage(AbstractWizardPage page) {
                Properties props = page.getProperties();
                try {
                    String cmdline = props.getProperty("Commandline");
                    adams.genetic.DarkLord genetic = (adams.genetic.DarkLord)OptionUtils.forAnyCommandLine(adams.genetic.DarkLord.class, (String)cmdline);
                    return genetic.getDataset().isFile() && genetic.getDataset().exists();
                }
                catch (Exception e) {
                    DarkLord.this.getLogger().log(Level.SEVERE, "Failed to obtain genetic algorithm setup:", e);
                    return false;
                }
            }
        });
        wizard.addPage((AbstractWizardPage)algorithm);
        FinalPage finalpage = new FinalPage();
        finalpage.setLogo(null);
        finalpage.setDescription("<html><h2>Ready</h2>Please click on <b>Execute</b> to start the optimization.</html>");
        wizard.addPage((AbstractWizardPage)finalpage);
        final ChildFrame frame = this.createChildFrame((Component)wizard, 800, 600);
        wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!e.getActionCommand().equals("Finish")) {
                    frame.dispose();
                    return;
                }
                Properties props = wizard.getProperties(false);
                adams.genetic.DarkLord genetic = null;
                try {
                    String cmdline = props.getProperty("Commandline");
                    genetic = (adams.genetic.DarkLord)OptionUtils.forAnyCommandLine(adams.genetic.DarkLord.class, (String)cmdline);
                }
                catch (Exception ex) {
                    GUIHelper.showErrorMessage(null, (String)("Failed to obtain genetic algorithm setup from wizard!\n" + Utils.throwableToString((Throwable)ex)));
                    return;
                }
                DarkLord.this.doOptimize(frame, genetic);
            }
        });
    }

    protected void doOptimize(ChildFrame frame, final adams.genetic.DarkLord genetic) {
        frame.dispose();
        JPanel panelAll = new JPanel(new BorderLayout());
        PerformancePlot plot = new PerformancePlot(genetic);
        panelAll.add((Component)((Object)plot), "Center");
        final JButton buttonPause = new JButton(GUIHelper.getIcon((String)"pause.gif"));
        final JButton buttonResume = new JButton(GUIHelper.getIcon((String)"resume.gif"));
        final JButton buttonStop = new JButton(GUIHelper.getIcon((String)"stop_blue.gif"));
        buttonPause.setEnabled(true);
        buttonResume.setEnabled(false);
        buttonStop.setEnabled(true);
        buttonPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                genetic.pauseExecution();
                buttonPause.setEnabled(!genetic.isPaused());
                buttonResume.setEnabled(genetic.isPaused());
            }
        });
        buttonResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                genetic.resumeExecution();
                buttonPause.setEnabled(!genetic.isPaused());
                buttonResume.setEnabled(genetic.isPaused());
            }
        });
        buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                genetic.stopExecution();
                buttonPause.setEnabled(false);
                buttonResume.setEnabled(false);
                buttonStop.setEnabled(false);
            }
        });
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        panelButtons.add(buttonPause);
        panelButtons.add(buttonResume);
        panelButtons.add(buttonStop);
        this.createChildFrame(panelAll, 800, 300);
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                genetic.run();
                return null;
            }

            @Override
            protected void done() {
                if (genetic.isStopped()) {
                    GUIHelper.showErrorMessage(null, (String)"Dark Lord stopped!");
                } else {
                    GUIHelper.showInformationMessage(null, (String)"Dark Lord finished!");
                }
                super.done();
            }
        };
        worker.execute();
    }

    public String getTitle() {
        return "Dark Lord";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.EXPERT;
    }

    public String getCategory() {
        return "Machine learning";
    }

    public static class PerformancePlot
    extends SequencePlotterPanel
    implements FitnessChangeListener {
        private static final long serialVersionUID = -4899150268392572586L;
        protected adams.genetic.DarkLord m_Owner;

        public PerformancePlot(adams.genetic.DarkLord owner) {
            super("Dark Lord");
            this.m_Owner = owner;
            this.m_Owner.addFitnessChangeListener(this);
            this.setTitle(owner.getMeasure().toString());
        }

        protected void initGUI() {
            super.initGUI();
            this.getPlot().setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
            AxisPanelOptions axis = this.getDefaultAxisX();
            axis.configure(this.getPlot(), Axis.BOTTOM);
            this.getPlot().setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
            axis = this.getDefaultAxisY();
            axis.configure(this.getPlot(), Axis.LEFT);
            this.setPaintlet((XYSequencePaintlet)new CirclePaintlet());
        }

        protected AxisPanelOptions getDefaultAxisX() {
            AxisPanelOptions result = new AxisPanelOptions();
            result.setType(Type.ABSOLUTE);
            result.setLabel("iteration");
            result.setShowGridLines(true);
            result.setLengthTicks(4);
            result.setNthValueToShow(2);
            result.setWidth(40);
            result.setTopMargin(0.0);
            result.setBottomMargin(0.0);
            result.setCustomFormat(new DecimalFormatString("0"));
            FancyTickGenerator tick = new FancyTickGenerator();
            tick.setNumTicks(20);
            result.setTickGenerator((TickGenerator)tick);
            return result;
        }

        protected AxisPanelOptions getDefaultAxisY() {
            AxisPanelOptions result = new AxisPanelOptions();
            result.setType(Type.ABSOLUTE);
            result.setLabel("measure");
            result.setShowGridLines(true);
            result.setLengthTicks(4);
            result.setNthValueToShow(2);
            result.setWidth(60);
            result.setTopMargin(0.0);
            result.setBottomMargin(0.0);
            result.setCustomFormat(new DecimalFormatString("0.0"));
            FancyTickGenerator tick = new FancyTickGenerator();
            tick.setNumTicks(10);
            result.setTickGenerator((TickGenerator)tick);
            return result;
        }

        @Override
        public void fitnessChanged(FitnessChangeEvent e) {
            SequencePlotSequence seq;
            String plotName = this.m_Owner.getMeasure().toString();
            XYSequenceContainerManager manager = (XYSequenceContainerManager)this.getContainerManager();
            manager.startUpdate();
            if (manager.indexOf(plotName) == -1) {
                seq = new SequencePlotSequence();
                seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
                seq.setID(plotName);
                XYSequenceContainer cont = manager.newContainer((Comparable)seq);
                manager.add(cont);
            } else {
                XYSequenceContainer cont = (XYSequenceContainer)manager.get(manager.indexOf(plotName));
                seq = cont.getData();
            }
            SequencePlotPoint point = new SequencePlotPoint((double)(seq.size() + 1), e.getFitness());
            seq.add((DataPoint)point);
            manager.finishUpdate();
        }
    }
}

