/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.meta.HighLowSplit;
import weka.classifiers.meta.LogTargetRegressor;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class HighLowSplitSingleClassifier
extends SingleClassifierEnhancer
implements WeightedInstancesHandler {
    private static final long serialVersionUID = -1948204213212845838L;
    protected Classifier m_loClassifier = new ZeroR();
    protected double m_loHipoint = 15.0;
    protected double m_splitpoint = 12.5;

    public String globalInfo() {
        return "Uses base classifier to get guess, then get prediction from either lo/hi classifier";
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.rules.ZeroR";
    }

    protected String[] defaultClassifierOptions() {
        return new String[0];
    }

    public Enumeration listOptions() {
        Vector newVector = new Vector();
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        newVector.addElement(new Option("\tHighest value for lo classifier\n\t(default: 15)\n", "P", 1, "-P <dbl>"));
        newVector.addElement(new Option("\tDecision boundary for hi/lo classifier\n\t(default: 12.5)\n", "E", 1, "-E <dbl>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String curropt = Utils.getOption((char)'P', (String[])options);
        if (curropt.length() != 0) {
            this.setLoHipoint(Double.parseDouble(curropt));
        } else {
            this.setLoHipoint(15.0);
        }
        curropt = Utils.getOption((char)'E', (String[])options);
        if (curropt.length() != 0) {
            this.setSplitpoint(Double.parseDouble(curropt));
        } else {
            this.setSplitpoint(12.5);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-P");
        result.add("" + this.getLoHipoint());
        result.add("-E");
        result.add("" + this.getSplitpoint());
        for (String option : super.getOptions()) {
            result.add(option);
        }
        return result.toArray(new String[result.size()]);
    }

    public double getLoHipoint() {
        return this.m_loHipoint;
    }

    public void setLoHipoint(double l) {
        this.m_loHipoint = l;
    }

    public String loHipointTipText() {
        return "low-high point";
    }

    public double getSplitpoint() {
        return this.m_splitpoint;
    }

    public void setSplitpoint(double s) {
        this.m_splitpoint = s;
    }

    public String splitpointTipText() {
        return "split point";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.setMinimumNumberInstances(1);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        LogTargetRegressor ltr = new LogTargetRegressor();
        Classifier c = AbstractClassifier.makeCopy((Classifier)this.getClassifier());
        ltr.setClassifier(c);
        this.m_loClassifier = ltr;
        this.m_Classifier.buildClassifier(data);
        Instances lo = new Instances(data, 0);
        for (Instance i : data) {
            if (!(i.classValue() <= this.m_loHipoint)) continue;
            DenseInstance in = new DenseInstance(i);
            in.setDataset(lo);
            lo.add((Instance)in);
        }
        this.m_loClassifier.buildClassifier(lo);
    }

    public double classifyInstance(Instance inst) throws Exception {
        double value = this.m_Classifier.classifyInstance(inst);
        if (value < this.getSplitpoint()) {
            return this.m_loClassifier.classifyInstance(inst);
        }
        return value;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Low-High point: " + this.getLoHipoint() + "\n");
        result.append("\nClassifier:\n" + this.m_Classifier + "\n");
        result.append("\nBelow " + this.m_splitpoint + ":\n" + this.m_loClassifier + "\n");
        result.append("\nElse:\n" + this.m_Classifier);
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 6936 $");
    }

    public static void main(String[] argv) {
        HighLowSplitSingleClassifier.runClassifier((Classifier)new HighLowSplit(), (String[])argv);
    }
}

