/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment.ext;

import java.io.File;
import java.util.logging.Level;
import weka.experiment.Experiment;
import weka.experiment.RemoteExperiment;
import weka.gui.experiment.ext.AbstractExperimentIO;
import weka.gui.experiment.ext.AbstractExperimentRunner;
import weka.gui.experiment.ext.DefaultExperimentRunner;
import weka.gui.experiment.ext.ExperimenterPanel;

public class DefaultExperimentIO
extends AbstractExperimentIO<Experiment> {
    private static final long serialVersionUID = -7678768486122004558L;

    @Override
    public Experiment create() {
        return new Experiment();
    }

    @Override
    public Experiment load(File file) {
        try {
            Experiment result = Experiment.read((String)file.getAbsolutePath());
            if (result instanceof RemoteExperiment) {
                result = ((RemoteExperiment)result).getBaseExperiment();
            }
            return result;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load experiment from " + file + "!", e);
            return null;
        }
    }

    @Override
    public boolean save(Experiment exp, File file) {
        try {
            Experiment.write((String)file.getAbsolutePath(), (Experiment)exp);
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write experiment to " + file + "!", e);
            return false;
        }
    }

    @Override
    public AbstractExperimentRunner createRunner(ExperimenterPanel owner) throws Exception {
        return new DefaultExperimentRunner(owner);
    }
}

