/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.meta.multisearch.Performance;
import weka.classifiers.meta.multisearch.PerformanceCache;
import weka.classifiers.meta.multisearch.PerformanceComparator;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Debug;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.SetupGenerator;
import weka.core.Summarizable;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.MathParameter;
import weka.core.setupgenerator.Point;
import weka.core.setupgenerator.Space;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.Resample;

public class MultiSearch
extends RandomizableSingleClassifierEnhancer
implements AdditionalMeasureProducer,
Summarizable {
    private static final long serialVersionUID = -5129316523575906233L;
    public static final Tag[] TAGS_EVALUATION = new Tag[]{new Tag(0, "CC", "Correlation coefficient"), new Tag(1, "RMSE", "Root mean squared error"), new Tag(2, "RRSE", "Root relative squared error"), new Tag(3, "MAE", "Mean absolute error"), new Tag(4, "RAE", "Root absolute error"), new Tag(5, "COMB", "Combined = (1-abs(CC)) + RRSE + RAE"), new Tag(6, "ACC", "Accuracy"), new Tag(7, "KAP", "Kappa")};
    protected Classifier m_BestClassifier;
    protected Point<Object> m_Values = null;
    protected int m_Evaluation = 0;
    protected SetupGenerator m_Generator;
    protected double m_SampleSize = 100.0;
    protected File m_LogFile = new File(System.getProperty("user.dir"));
    protected Space m_Space;
    protected PerformanceCache m_Cache;
    protected boolean m_UniformPerformance = false;
    protected FilteredClassifier m_FilteredClassifier;
    protected AbstractParameter[] m_DefaultParameters;
    protected int m_InitialSpaceNumFolds = 2;
    protected int m_SubsequentSpaceNumFolds = 10;
    protected int m_NumExecutionSlots = 1;
    protected transient ThreadPoolExecutor m_ExecutorPool;
    protected int m_Completed;
    protected int m_Failed;
    protected int m_NumSetups;
    protected Vector<Performance> m_Performances;

    public MultiSearch() {
        this.m_Generator = new SetupGenerator();
        LinearRegression classifier = new LinearRegression();
        classifier.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
        classifier.setEliminateColinearAttributes(false);
        this.m_Classifier = classifier;
        AbstractParameter[] params = new AbstractParameter[1];
        MathParameter param = new MathParameter();
        param.setProperty("classifier.ridge");
        param.setMin(-10.0);
        param.setMax(5.0);
        param.setStep(1.0);
        param.setBase(10.0);
        param.setExpression("pow(BASE,I)");
        params[0] = param;
        try {
            this.m_DefaultParameters = (AbstractParameter[])new SerializedObject((Object)params).getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_Generator.setBaseObject((Serializable)((Object)this));
        this.m_Generator.setParameters(params);
        try {
            this.m_BestClassifier = AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String globalInfo() {
        return "Performs a search of an arbitrary number of parameters of a classifier and chooses the best pair found for the actual filtering and training.\nThe default MultiSearch is using the following FilteredClassifier setup:\n - classifier: LinearRegression, searching for the \"Ridge\"\n - filter: PLSFilter, searching for the \"# of Components\"\nThe properties being explored are totally up to the user, it can be a mix of classifier and filter properties, or only classifier ones or only filter ones.\n\nSince the the MultiSearch classifier itself is used as the base object for the setups being generated, one has to prefix the properties with 'classifier.' (referring to MultiSearch's 'classifier' property).\nE.g., if you have a FilteredClassifier selected as base classifier, sporting a PLSFilter and you want to explore the number of PLS components, then your property will be made up of the following components:\n - classifier: referring to MultiSearch's classifier property\n   i.e., the FilteredClassifier.\n - filter: referring to the FilteredClassifier's property (= PLSFilter)\n - numComponents: the actual property of the PLSFilter that we want to modify\nAnd assembled, the property looks like this:\n  classifier.filter.numComponents\n\nThe initial space is worked on with 2-fold CV to determine the values of the parameters for the selected type of evaluation (e.g., accuracy). The best point in the space is then taken as center and a 10-fold CV is performed with the adjacent parameters. If better parameters are found, then this will act as new center and another 10-fold CV will be performed (kind of hill-climbing). This process is repeated until no better pair is found or the best pair is on the border of the parameter space.\nThe number of CV-folds for the initial and subsequent spaces can be adjusted, of course.\n\nThe outcome of a mathematical function (= double), MultiSearch will convert to integers (values are just cast to int), booleans (0 is false, otherwise true), float, char and long if necessary.\nVia a user-supplied 'list' of parameters (blank-separated), one can also set strings and selected tags (drop-down comboboxes in Weka's GenericObjectEditor). Classnames with options (e.g., classifiers with their options) are possible as well.\n\nThe best classifier setup can be accessed after the buildClassifier call via the getBestClassifier method.";
    }

    protected String defaultClassifierString() {
        return FilteredClassifier.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        String desc = "";
        for (int i = 0; i < TAGS_EVALUATION.length; ++i) {
            SelectedTag tag = new SelectedTag(TAGS_EVALUATION[i].getID(), TAGS_EVALUATION);
            desc = desc + "\t" + tag.getSelectedTag().getIDStr() + " = " + tag.getSelectedTag().getReadable() + "\n";
        }
        result.addElement(new Option("\tDetermines the parameter used for evaluation:\n" + desc + "\t(default: " + new SelectedTag(0, TAGS_EVALUATION) + ")", "E", 1, "-E " + Tag.toOptionList((Tag[])TAGS_EVALUATION)));
        result.addElement(new Option("\tA property search setup.\n", "search", 1, "-search \"<classname options>\""));
        result.addElement(new Option("\tThe size (in percent) of the sample to search the inital space with.\n\t(default: 100)", "sample-size", 1, "-sample-size <num>"));
        result.addElement(new Option("\tThe log file to log the messages to.\n\t(default: none)", "log-file", 1, "-log-file <filename>"));
        result.addElement(new Option("\tThe number of cross-validation folds for the initial space.\n\tNumbers smaller than 2 turn off cross-validation and just\n\tperform evaluation on the training set.\n\t(default: 2)", "initial-folds", 1, "-initial-folds <num>"));
        result.addElement(new Option("\tThe number of cross-validation folds for the subsequent sub-spaces.\n\tNumbers smaller than 2 turn off cross-validation and just\n\tperform evaluation on the training set.\n\t(default: 10)", "subsequent-folds", 1, "-subsequent-folds <num>"));
        result.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)", "num-slots", 1, "-num-slots <num>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        result.add("-E");
        result.add("" + this.getEvaluation());
        for (i = 0; i < this.m_Generator.getParameters().length; ++i) {
            result.add("-search");
            result.add(this.getCommandline(this.m_Generator.getParameters()[i]));
        }
        result.add("-sample-size");
        result.add("" + this.getSampleSizePercent());
        result.add("-log-file");
        result.add("" + this.getLogFile());
        result.add("-initial-folds");
        result.add("" + this.getInitialSpaceNumFolds());
        result.add("-subsequent-folds");
        result.add("" + this.getSubsequentSpaceNumFolds());
        result.add("-num-slots");
        result.add("" + this.getNumExecutionSlots());
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        int i;
        String tmpStr = Utils.getOption((char)'E', (String[])options);
        if (tmpStr.length() != 0) {
            this.setEvaluation(new SelectedTag(tmpStr, TAGS_EVALUATION));
        } else {
            this.setEvaluation(new SelectedTag(0, TAGS_EVALUATION));
        }
        Vector<String> search = new Vector<String>();
        do {
            if ((tmpStr = Utils.getOption((String)"search", (String[])options)).length() <= 0) continue;
            search.add(tmpStr);
        } while (tmpStr.length() > 0);
        if (search.size() == 0) {
            for (i = 0; i < this.m_DefaultParameters.length; ++i) {
                search.add(this.getCommandline(this.m_DefaultParameters[i]));
            }
        }
        AbstractParameter[] params = new AbstractParameter[search.size()];
        for (i = 0; i < search.size(); ++i) {
            String[] tmpOptions = Utils.splitOptions((String)((String)search.get(i)));
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            params[i] = (AbstractParameter)Utils.forName(AbstractParameter.class, (String)tmpStr, (String[])tmpOptions);
        }
        this.m_Generator.setParameters(params);
        tmpStr = Utils.getOption((String)"sample-size", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(tmpStr));
        } else {
            this.setSampleSizePercent(100.0);
        }
        tmpStr = Utils.getOption((String)"log-file", (String[])options);
        if (tmpStr.length() != 0) {
            this.setLogFile(new File(tmpStr));
        } else {
            this.setLogFile(new File(System.getProperty("user.dir")));
        }
        tmpStr = Utils.getOption((String)"initial-folds", (String[])options);
        if (tmpStr.length() != 0) {
            this.setInitialSpaceNumFolds(Integer.parseInt(tmpStr));
        } else {
            this.setInitialSpaceNumFolds(2);
        }
        tmpStr = Utils.getOption((String)"subsequent-folds", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSubsequentSpaceNumFolds(Integer.parseInt(tmpStr));
        } else {
            this.setSubsequentSpaceNumFolds(10);
        }
        tmpStr = Utils.getOption((String)"num-slots", (String[])options);
        if (tmpStr.length() != 0) {
            this.setNumExecutionSlots(Integer.parseInt(tmpStr));
        } else {
            this.setNumExecutionSlots(1);
        }
        super.setOptions(options);
    }

    public void setClassifier(Classifier newClassifier) {
        boolean nominal;
        Capabilities cap = newClassifier.getCapabilities();
        boolean numeric = cap.handles(Capabilities.Capability.NUMERIC_CLASS) || cap.hasDependency(Capabilities.Capability.NUMERIC_CLASS);
        boolean bl = nominal = cap.handles(Capabilities.Capability.NOMINAL_CLASS) || cap.hasDependency(Capabilities.Capability.NOMINAL_CLASS) || cap.handles(Capabilities.Capability.BINARY_CLASS) || cap.hasDependency(Capabilities.Capability.BINARY_CLASS) || cap.handles(Capabilities.Capability.UNARY_CLASS) || cap.hasDependency(Capabilities.Capability.UNARY_CLASS);
        if (this.m_Evaluation == 0 && !numeric) {
            throw new IllegalArgumentException("Classifier needs to handle numeric class for chosen type of evaluation!");
        }
        if (!(this.m_Evaluation != 6 && this.m_Evaluation != 7 || nominal)) {
            throw new IllegalArgumentException("Classifier needs to handle nominal class for chosen type of evaluation!");
        }
        super.setClassifier(newClassifier);
        try {
            this.m_BestClassifier = AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String searchParametersTipText() {
        return "Defines the search parameters.";
    }

    public void setSearchParameters(AbstractParameter[] value) {
        this.m_Generator.setParameters((AbstractParameter[])value.clone());
    }

    public AbstractParameter[] getSearchParameters() {
        return this.m_Generator.getParameters();
    }

    public String evaluationTipText() {
        return "Sets the criterion for evaluating the classifier performance and choosing the best one.";
    }

    public void setEvaluation(SelectedTag value) {
        if (value.getTags() == TAGS_EVALUATION) {
            this.m_Evaluation = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getEvaluation() {
        return new SelectedTag(this.m_Evaluation, TAGS_EVALUATION);
    }

    public String sampleSizePercentTipText() {
        return "The sample size (in percent) to use in the initial space search.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSize;
    }

    public void setSampleSizePercent(double value) {
        this.m_SampleSize = value;
    }

    public String logFileTipText() {
        return "The log file to log the messages to.";
    }

    public File getLogFile() {
        return this.m_LogFile;
    }

    public void setLogFile(File value) {
        this.m_LogFile = value;
    }

    public String initialSpaceNumFoldsTipText() {
        return "The number of cross-validation folds when evaluating the initial space; values smaller than 2 turn cross-validation off and simple evaluation on the training set is performed.";
    }

    public int getInitialSpaceNumFolds() {
        return this.m_InitialSpaceNumFolds;
    }

    public void setInitialSpaceNumFolds(int value) {
        this.m_InitialSpaceNumFolds = value;
    }

    public String subsequentSpaceNumFoldsTipText() {
        return "The number of cross-validation folds when evaluating the subsequent sub-spaces; values smaller than 2 turn cross-validation off and simple evaluation on the training set is performed.";
    }

    public int getSubsequentSpaceNumFolds() {
        return this.m_SubsequentSpaceNumFolds;
    }

    public void setSubsequentSpaceNumFolds(int value) {
        this.m_SubsequentSpaceNumFolds = value;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use for constructing the ensemble.";
    }

    public void setNumExecutionSlots(int value) {
        if (value >= 1) {
            this.m_NumExecutionSlots = value;
        }
    }

    public int getNumExecutionSlots() {
        return this.m_NumExecutionSlots;
    }

    public Classifier getBestClassifier() {
        return this.m_BestClassifier;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.m_Values.dimensions(); ++i) {
            if (!(this.m_Values.getValue(i) instanceof Double)) continue;
            result.add("measure-" + i);
        }
        return result.elements();
    }

    public double getMeasure(String measureName) {
        if (measureName.startsWith("measure-")) {
            return (Double)this.m_Generator.evaluate(this.getValues()).getValue(Integer.parseInt(measureName.replace("measure-", "")));
        }
        throw new IllegalArgumentException("Measure '" + measureName + "' not supported!");
    }

    public Point<Object> getValues() {
        return this.m_Values;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        Capabilities classes = result.getClassCapabilities();
        Iterator iter = classes.capabilities();
        while (iter.hasNext()) {
            Capabilities.Capability capab = (Capabilities.Capability)iter.next();
            if (capab == Capabilities.Capability.BINARY_CLASS || capab == Capabilities.Capability.NOMINAL_CLASS || capab == Capabilities.Capability.NUMERIC_CLASS || capab == Capabilities.Capability.DATE_CLASS) continue;
            result.disable(capab);
        }
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        if (result.getMinimumNumberInstances() < 1) {
            result.setMinimumNumberInstances(1);
        }
        result.setOwner((CapabilitiesHandler)this);
        return result;
    }

    protected String getCommandline(Object obj) {
        String result = obj.getClass().getName();
        if (obj instanceof OptionHandler) {
            result = result + " " + Utils.joinOptions((String[])((OptionHandler)obj).getOptions());
        }
        return result.trim();
    }

    protected void log(String message) {
        this.log(message, false);
    }

    protected void log(String message, boolean onlyLog) {
        if (this.getDebug() && !onlyLog) {
            System.out.println(message);
        }
        if (!this.getLogFile().isDirectory()) {
            Debug.writeToFile((String)this.getLogFile().getAbsolutePath(), (String)message, (boolean)true);
        }
    }

    protected String[] updateOption(String[] options, String option, String value) throws Exception {
        Utils.getOption((String)option, (String[])options);
        Vector<String> tmpOptions = new Vector<String>();
        tmpOptions.add("-" + option);
        tmpOptions.add("" + value);
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() == 0) continue;
            tmpOptions.add(options[i]);
        }
        String[] result = tmpOptions.toArray(new String[tmpOptions.size()]);
        return result;
    }

    protected String logPerformances(Space space, Vector<Performance> performances, Tag type) {
        StringBuffer result = new StringBuffer(type.getReadable() + ":\n");
        result.append(space.toString());
        result.append("\n");
        for (int i = 0; i < performances.size(); ++i) {
            result.append(performances.get(i).getPerformance(type.getID()));
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    protected void logPerformances(Space space, Vector<Performance> performances) {
        for (int i = 0; i < TAGS_EVALUATION.length; ++i) {
            this.log("\n" + this.logPerformances(space, performances, TAGS_EVALUATION[i]), true);
        }
    }

    protected void startExecutorPool() {
        this.stopExecutorPool();
        this.log("Starting thread pool with " + this.m_NumExecutionSlots + " slots...");
        this.m_ExecutorPool = new ThreadPoolExecutor(this.m_NumExecutionSlots, this.m_NumExecutionSlots, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    protected void stopExecutorPool() {
        this.log("Shutting down thread pool...");
        if (this.m_ExecutorPool != null) {
            this.m_ExecutorPool.shutdownNow();
        }
        this.m_ExecutorPool = null;
    }

    protected synchronized void block(boolean doBlock) {
        if (doBlock) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            ((Object)((Object)this)).notifyAll();
        }
    }

    protected synchronized void completedEvaluation(Object obj, boolean success) {
        if (!success) {
            ++this.m_Failed;
            if (this.m_Debug) {
                if (obj instanceof Classifier) {
                    System.err.println("Training failed: " + this.getCommandline(obj));
                } else {
                    System.err.println("Training failed: " + obj);
                }
            }
        } else {
            ++this.m_Completed;
        }
        if (this.m_Completed + this.m_Failed == this.m_NumSetups) {
            if (this.m_Failed > 0 && this.m_Debug) {
                System.err.println("Problem building classifiers - some failed to be trained.");
            }
            this.block(false);
        }
    }

    protected void addPerformance(Performance performance, int folds) {
        if (this.m_Failed > 0) {
            return;
        }
        this.m_Performances.add(performance);
        this.m_Cache.add(folds, performance);
    }

    protected Point<Object> determineBestInSpace(Space space, Instances inst, int folds) throws Exception {
        this.m_Performances.clear();
        if (folds >= 2) {
            this.log("Determining best values with " + folds + "-fold CV in space:\n" + space + "\n");
        } else {
            this.log("Determining best values with evaluation on training set in space:\n" + space + "\n");
        }
        Enumeration<Point<Object>> enm = space.values();
        boolean allCached = true;
        this.m_Failed = 0;
        this.m_Completed = 0;
        this.m_NumSetups = space.size();
        while (enm.hasMoreElements()) {
            Point<Object> values = enm.nextElement();
            if (this.m_Cache.isCached(folds, values)) {
                Performance performance = this.m_Cache.get(folds, values);
                this.m_Performances.add(performance);
                this.log(performance + ": cached=true");
                ++this.m_Completed;
                continue;
            }
            allCached = false;
            EvaluationTask newTask = new EvaluationTask(this, inst, this.m_Generator, values, folds, this.m_Evaluation);
            this.m_ExecutorPool.execute(newTask);
        }
        if (this.m_Completed + this.m_Failed < this.m_NumSetups) {
            this.block(true);
        }
        if (allCached) {
            this.log("All points were already cached - abnormal state!");
            throw new IllegalStateException("All points were already cached - abnormal state!");
        }
        if (this.m_Failed > 0) {
            throw new WekaException("Failed to evaluate " + this.m_Failed + " setups!");
        }
        Collections.sort(this.m_Performances, new PerformanceComparator(this.m_Evaluation));
        Point<Object> result = this.m_Performances.lastElement().getValues();
        this.m_UniformPerformance = true;
        Performance p1 = this.m_Performances.get(0);
        for (int i = 1; i < this.m_Performances.size(); ++i) {
            Performance p2 = this.m_Performances.get(i);
            if (p2.getPerformance(this.m_Evaluation) == p1.getPerformance(this.m_Evaluation)) continue;
            this.m_UniformPerformance = false;
            break;
        }
        if (this.m_UniformPerformance) {
            this.log("All performances are the same!");
        }
        this.logPerformances(space, this.m_Performances);
        this.log("\nBest performance:\n" + this.m_Performances.lastElement());
        this.m_Performances.clear();
        return result;
    }

    protected Point<Object> findBest(Instances inst) throws Exception {
        Instances sample;
        this.log("Step 1:\n");
        if (this.getSampleSizePercent() == 100.0) {
            sample = inst;
        } else {
            this.log("Generating sample (" + this.getSampleSizePercent() + "%)");
            Resample resample = new Resample();
            resample.setRandomSeed(this.getSeed());
            resample.setSampleSizePercent(this.getSampleSizePercent());
            resample.setInputFormat(inst);
            sample = Filter.useFilter((Instances)inst, (Filter)resample);
        }
        boolean finished = false;
        int iteration = 0;
        this.m_UniformPerformance = false;
        this.log("\n=== Initial space - Start ===");
        Point<Object> result = this.determineBestInSpace(this.m_Space, sample, this.m_InitialSpaceNumFolds);
        this.log("\nResult of Step 1: " + result + "\n");
        this.log("=== Initial space - End ===\n");
        finished = this.m_UniformPerformance;
        if (!finished) {
            do {
                ++iteration;
                Point resultOld = (Point)result.clone();
                Point<Integer> center = this.m_Space.getLocations(result);
                if (this.m_Space.isOnBorder(center)) {
                    this.log("Center is on border of space.");
                    finished = true;
                }
                if (finished) continue;
                Space neighborSpace = this.m_Space.subspace(center);
                result = this.determineBestInSpace(neighborSpace, sample, this.m_SubsequentSpaceNumFolds);
                this.log("\nResult of Step 2/Iteration " + iteration + ":\n" + result);
                finished = this.m_UniformPerformance;
                if (!result.equals(resultOld)) continue;
                finished = true;
                this.log("\nNo better point found.");
            } while (!finished);
        }
        this.log("\nFinal result:" + result);
        Point<Object> evals = this.m_Generator.evaluate(result);
        MultiSearch multi = (MultiSearch)((Object)this.m_Generator.setup((Serializable)((Object)this), evals));
        this.log("Classifier: " + this.getCommandline(multi.getClassifier()));
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_Cache = new PerformanceCache();
        this.m_Performances = new Vector();
        this.startExecutorPool();
        this.m_Generator.reset();
        this.m_Space = this.m_Generator.getSpace();
        this.log("\n" + ((Object)((Object)this)).getClass().getName() + "\n" + ((Object)((Object)this)).getClass().getName().replaceAll(".", "=") + "\n" + "Options: " + Utils.joinOptions((String[])this.getOptions()) + "\n");
        this.m_Values = this.findBest(new Instances(data));
        this.stopExecutorPool();
        Point<Object> evals = this.m_Generator.evaluate(this.m_Values);
        MultiSearch multi = (MultiSearch)((Object)this.m_Generator.setup((Serializable)((Object)this), evals));
        this.m_BestClassifier = multi.getClassifier();
        this.m_Classifier = AbstractClassifier.makeCopy((Classifier)this.m_BestClassifier);
        this.m_Classifier.buildClassifier(data);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Classifier.distributionForInstance(instance);
    }

    public String toString() {
        String result = "";
        if (this.m_Values == null) {
            result = "No search performed yet.";
        } else {
            result = ((Object)((Object)this)).getClass().getName() + ":\n" + "Classifier: " + this.getCommandline(this.getBestClassifier()) + "\n\n";
            for (int i = 0; i < this.m_Generator.getParameters().length; ++i) {
                result = result + (i + 1) + ". property: " + this.m_Generator.getParameters()[i].getProperty() + "\n";
            }
            result = result + "Evaluation: " + this.getEvaluation().getSelectedTag().getReadable() + "\n" + "Coordinates: " + this.getValues() + "\n";
            result = result + "Values: " + this.m_Generator.evaluate(this.getValues()) + "\n\n" + this.m_Classifier.toString();
        }
        return result;
    }

    public String toSummaryString() {
        String result = "Best classifier: " + this.getCommandline(this.getBestClassifier());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        MultiSearch.runClassifier((Classifier)new MultiSearch(), (String[])args);
    }

    protected static class EvaluationTask
    implements Runnable {
        protected MultiSearch m_Owner;
        protected Instances m_Data;
        protected SetupGenerator m_Generator;
        protected Point<Object> m_Values;
        protected int m_Folds;
        protected int m_Evaluation = 0;

        public EvaluationTask(MultiSearch owner, Instances inst, SetupGenerator generator, Point<Object> values, int folds, int eval) {
            this.m_Owner = owner;
            this.m_Data = inst;
            this.m_Generator = generator;
            this.m_Values = values;
            this.m_Folds = folds;
            this.m_Evaluation = eval;
        }

        @Override
        public void run() {
            try {
                boolean completed;
                Evaluation eval;
                Point<Object> evals = this.m_Generator.evaluate(this.m_Values);
                MultiSearch multi = (MultiSearch)((Object)this.m_Generator.setup((Serializable)((Object)this.m_Owner), evals));
                Classifier classifier = multi.getClassifier();
                try {
                    eval = new Evaluation(this.m_Data);
                    eval.setDiscardPredictions(true);
                    if (this.m_Folds >= 2) {
                        eval.crossValidateModel(classifier, this.m_Data, this.m_Folds, new Random(this.m_Owner.getSeed()), new Object[0]);
                    } else {
                        classifier.buildClassifier(this.m_Data);
                        eval.evaluateModel(classifier, this.m_Data, new Object[0]);
                    }
                    completed = true;
                }
                catch (Exception e) {
                    eval = null;
                    System.err.println("Encountered exception while evaluating classifier, skipping!");
                    System.err.println("- Classifier: " + this.m_Owner.getCommandline(classifier));
                    e.printStackTrace();
                    completed = false;
                }
                Performance performance = new Performance(this.m_Values, eval, this.m_Evaluation);
                this.m_Owner.addPerformance(performance, this.m_Folds);
                this.m_Owner.log(performance + ": cached=false");
                this.m_Owner.completedEvaluation(classifier, completed);
            }
            catch (Exception e) {
                System.err.println("Encountered exception while evaluating classifier, skipping!");
                System.err.println("- Values: " + this.m_Values);
                e.printStackTrace();
                this.m_Owner.completedEvaluation(this.m_Values, false);
            }
            this.m_Owner = null;
            this.m_Data = null;
            this.m_Generator = null;
            this.m_Values = null;
        }
    }
}

