/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import adams.data.io.input.CNTKSpreadSheetReader;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;

public class CNTKLoader
extends AbstractFileLoader
implements BatchConverter,
OptionHandler {
    private static final long serialVersionUID = 532290589164256915L;
    protected Instances m_structure = null;
    protected Instances m_Data = null;
    protected File m_sourceFile = new File(System.getProperty("user.dir"));
    protected boolean m_Debug = false;
    protected String m_ClassGroup = "";

    public CNTKLoader() {
        this.setRetrieval(0);
    }

    public String globalInfo() {
        return "Reads CNTK data files in text format.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, (String)this.debugTipText(), (String)"off", (String)"D");
        WekaOptionUtils.addOption(result, (String)this.classGroupTipText(), (String)this.getDefaultClassGroup(), (String)"class-group");
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag((String)"D", (String[])options));
        this.setClassGroup(WekaOptionUtils.parse((String[])options, (String)"class-group", (String)this.getDefaultClassGroup()));
    }

    public String[] getOptions() {
        ArrayList result = new ArrayList();
        WekaOptionUtils.add(result, (String)"D", (boolean)this.getDebug());
        WekaOptionUtils.add(result, (String)"class-group", (String)this.getClassGroup());
        return WekaOptionUtils.toArray(result);
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Whether to print additional debug information to the console.";
    }

    public String getDefaultClassGroup() {
        return "";
    }

    public void setClassGroup(String value) {
        this.m_ClassGroup = value;
    }

    public String getClassGroup() {
        return this.m_ClassGroup;
    }

    public String classGroupTipText() {
        return "The group representing the class attribute.";
    }

    public String getFileExtension() {
        return this.getFileExtensions()[0];
    }

    public String[] getFileExtensions() {
        return new String[]{"txt"};
    }

    public String getFileDescription() {
        return "CNTK Text file";
    }

    public void reset() throws IOException {
        super.reset();
        this.m_structure = null;
        this.m_Data = null;
    }

    public void setSource(File file) throws IOException {
        File original = file;
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        String fName = file.getPath();
        try {
            if (this.m_env == null) {
                this.m_env = Environment.getSystemWide();
            }
            fName = this.m_env.substitute(fName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        file = new File(fName);
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File '" + file + "' not found or not an actual file!");
        }
        this.m_sourceFile = file;
        if (this.m_useRelativePath) {
            try {
                this.m_sourceFile = Utils.convertToRelativePath((File)original);
                this.m_File = this.m_sourceFile.getPath();
            }
            catch (Exception ex) {
                this.m_sourceFile = original;
                this.m_File = this.m_sourceFile.getPath();
            }
        } else {
            this.m_sourceFile = original;
            this.m_File = this.m_sourceFile.getPath();
        }
    }

    public Instances getStructure() throws IOException {
        if (this.m_structure == null) {
            int i;
            CNTKSpreadSheetReader reader;
            SpreadSheet sheet;
            if (this.m_Debug) {
                System.out.println("Loading data from '" + this.m_sourceFile + "'...");
            }
            if ((sheet = (reader = new CNTKSpreadSheetReader()).read(this.m_sourceFile.getAbsolutePath())) == null) {
                throw new IOException("Failed to read: " + this.m_sourceFile);
            }
            TIntArrayList classCols = new TIntArrayList();
            if (!this.m_ClassGroup.isEmpty()) {
                Pattern classCol = Pattern.compile(this.m_ClassGroup + "-[0-9]+");
                for (i = 0; i < sheet.getColumnCount(); ++i) {
                    if (!classCol.matcher(sheet.getHeaderRow().getContent(i)).matches()) continue;
                    classCols.add(i);
                }
                if (this.getDebug()) {
                    System.out.println("Class group '" + this.m_ClassGroup + "' consists of " + classCols.size() + " columns");
                }
            }
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            for (i = 0; i < sheet.getColumnCount(); ++i) {
                if (classCols.contains(i)) continue;
                atts.add(new Attribute(sheet.getColumnName(i)));
            }
            if (classCols.size() == 1) {
                atts.add(new Attribute(this.m_ClassGroup));
                if (this.getDebug()) {
                    System.out.println("Class attribute: " + atts.get(atts.size() - 1));
                }
            } else if (classCols.size() > 1) {
                ArrayList<String> labels = new ArrayList<String>();
                for (i = 0; i < classCols.size(); ++i) {
                    labels.add("" + (i + 1));
                }
                atts.add(new Attribute(this.m_ClassGroup, labels));
                if (this.getDebug()) {
                    System.out.println("Class attribute: " + atts.get(atts.size() - 1));
                }
            }
            this.m_Data = new Instances(this.m_sourceFile.getName(), atts, sheet.getRowCount());
            if (classCols.size() > 0) {
                this.m_Data.setClassIndex(this.m_Data.numAttributes() - 1);
            }
            for (Row row : sheet.rows()) {
                double[] values = new double[this.m_Data.numAttributes()];
                int missing = 0;
                for (i = 0; i < values.length; ++i) {
                    values[i] = Utils.missingValue();
                    if (classCols.contains(i)) continue;
                    if (row.hasCell(i) && !row.getCell(i).isMissing()) {
                        values[i] = row.getCell(i).toDouble();
                        continue;
                    }
                    ++missing;
                }
                if (classCols.size() == 1) {
                    i = classCols.get(0);
                    if (row.hasCell(i) && !row.getCell(i).isMissing()) {
                        values[values.length - 1] = row.getCell(i).toDouble();
                    }
                } else if (classCols.size() > 1) {
                    int labelIndex = 0;
                    for (i = 0; i < classCols.size(); ++i) {
                        if (row.hasCell(i) && !row.getCell(i).isMissing() && row.getCell(i).toDouble() > 0.0) {
                            values[values.length - 1] = labelIndex;
                            break;
                        }
                        ++labelIndex;
                    }
                }
                Object inst = missing > 0 ? new SparseInstance(1.0, values) : new DenseInstance(1.0, values);
                this.m_Data.add((Instance)inst);
            }
            this.m_structure = new Instances(this.m_Data, 0);
        }
        return this.m_structure;
    }

    public Instances getDataSet() throws IOException {
        this.getStructure();
        return this.m_Data;
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("CNTKLoader can't read data sets incrementally.");
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        adams.env.Environment.setEnvironmentClass(adams.env.Environment.class);
        CNTKLoader.runFileLoader((AbstractFileLoader)new CNTKLoader(), (String[])args);
    }
}

