/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import adams.core.Index;
import adams.core.Range;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.management.LocaleHelper;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaOptionUtils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;

public class CNTKSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = 4351243795790752863L;
    protected boolean m_Debug = false;
    protected Index m_RowID;
    protected Range[] m_Inputs;
    protected BaseString[] m_InputNames;
    protected boolean m_UseSparseFormat;
    protected boolean m_SuppressMissing;
    protected File m_OutputFile;
    protected Locale m_Locale;

    public CNTKSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes the Instances to a CNTK text file.\nAutomatically turns a nominal class attribute into CNTK's '1-hot encoding'.";
    }

    public void resetOptions() {
        super.resetOptions();
        this.m_RowID = this.getDefaultRowID();
        this.m_Inputs = this.getDefaultInputs();
        this.m_InputNames = this.getDefaultInputNames();
        this.m_UseSparseFormat = false;
        this.m_SuppressMissing = false;
        this.m_OutputFile = null;
        this.m_Locale = LocaleHelper.getSingleton().getDefault();
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        WekaOptionUtils.addOption(result, (String)this.debugTipText(), (String)"off", (String)"D");
        WekaOptionUtils.addOption(result, (String)this.rowIDTipText(), (Index)this.getDefaultRowID(), (String)"row-id");
        WekaOptionUtils.addOption(result, (String)this.inputsTipText(), (String)Utils.arrayToString((Object)this.getDefaultInputs()), (String)"inputs");
        WekaOptionUtils.addOption(result, (String)this.inputNamesTipText(), (String)Utils.arrayToString((Object)this.getDefaultInputNames()), (String)"input-names");
        WekaOptionUtils.addOption(result, (String)this.useSparseFormatTipText(), (String)"no", (String)"use-sparse-format");
        WekaOptionUtils.addOption(result, (String)this.suppressMissingTipText(), (String)"no", (String)"suppress-missing");
        return WekaOptionUtils.toEnumeration(result);
    }

    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag((String)"D", (String[])options));
        this.setRowID(WekaOptionUtils.parse((String[])options, (String)"row-id", (Index)this.getDefaultRowID()));
        this.setInputs(WekaOptionUtils.parse((String[])options, (String)"inputs", (Range[])this.getDefaultInputs()));
        this.setInputNames((BaseString[])WekaOptionUtils.parse((String[])options, (String)"input-names", (BaseObject[])this.getDefaultInputNames()));
        this.setUseSparseFormat(Utils.getFlag((String)"use-sparse-format", (String[])options));
        this.setSuppressMissing(Utils.getFlag((String)"suppress-missing", (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        WekaOptionUtils.add(result, (String)"D", (boolean)this.getDebug());
        if (!this.getRowID().isEmpty()) {
            WekaOptionUtils.add(result, (String)"row-id", (Index)this.getRowID());
        }
        WekaOptionUtils.add(result, (String)"inputs", (Range[])this.getInputs());
        WekaOptionUtils.add(result, (String)"input-names", (BaseObject[])this.getInputNames());
        WekaOptionUtils.add(result, (String)"use-sparse-format", (boolean)this.getUseSparseFormat());
        WekaOptionUtils.add(result, (String)"suppress-missing", (boolean)this.getSuppressMissing());
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public String getFileDescription() {
        return "CNTK Text file";
    }

    public String[] getFileExtensions() {
        return new String[]{".txt"};
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Whether to print additional debug information to the console.";
    }

    protected Index getDefaultRowID() {
        return new Index();
    }

    public void setRowID(Index value) {
        this.m_RowID = value;
    }

    public Index getRowID() {
        return this.m_RowID;
    }

    public String rowIDTipText() {
        return "The (optional) attribute to use for the row ID.";
    }

    protected Range[] getDefaultInputs() {
        return new Range[0];
    }

    public void setInputs(Range[] value) {
        this.m_Inputs = value;
        this.m_InputNames = (BaseString[])adams.core.Utils.adjustArray((Object)this.m_InputNames, (int)this.m_Inputs.length, (Object)new BaseString());
    }

    public Range[] getInputs() {
        return this.m_Inputs;
    }

    public String inputsTipText() {
        return "The attribute ranges determining the inputs (eg for 'features' and 'class').";
    }

    protected BaseString[] getDefaultInputNames() {
        return new BaseString[0];
    }

    public void setInputNames(BaseString[] value) {
        this.m_InputNames = value;
        this.m_Inputs = (Range[])adams.core.Utils.adjustArray((Object)this.m_Inputs, (int)this.m_InputNames.length, (Object)new Range());
    }

    public BaseString[] getInputNames() {
        return this.m_InputNames;
    }

    public String inputNamesTipText() {
        return "The names of the inputs (eg 'features' and 'class').";
    }

    public void setUseSparseFormat(boolean value) {
        this.m_UseSparseFormat = value;
    }

    public boolean getUseSparseFormat() {
        return this.m_UseSparseFormat;
    }

    public String useSparseFormatTipText() {
        return "If enabled, sparse format is used instead (ie 'index:value').";
    }

    public void setSuppressMissing(boolean value) {
        this.m_SuppressMissing = value;
    }

    public boolean getSuppressMissing() {
        return this.m_SuppressMissing;
    }

    public String suppressMissingTipText() {
        return "If enabled, groups that contain at least one missing value get suppressed completely.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void setDestination(File file) throws IOException {
        this.m_OutputFile = file;
    }

    public void setDestination(OutputStream output) throws IOException {
        throw new IOException("Writing to an outputstream not supported");
    }

    protected synchronized String format(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.isInfinite(value)) {
            if (value < 0.0) {
                return "-Infinity";
            }
            return "+Infinity";
        }
        String result = adams.core.Utils.doubleToString((double)value, (int)12, (Locale)this.m_Locale);
        return result;
    }

    public void writeBatch() throws IOException {
        int r;
        int n;
        int i;
        if (this.getInstances() == null) {
            throw new IOException("No instances to save!");
        }
        Instances data = this.getInstances();
        if (this.m_OutputFile == null) {
            throw new IOException("No output file set!");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.m_Inputs.length == 0) {
            throw new IllegalStateException("No input ranges defined!");
        }
        this.m_InputNames = (BaseString[])adams.core.Utils.adjustArray((Object)this.m_InputNames, (int)this.m_Inputs.length, (Object)new BaseString());
        String[] names = new String[this.m_InputNames.length];
        for (i = 0; i < this.m_InputNames.length; ++i) {
            names[i] = this.m_InputNames[i].getValue();
            if (!names[i].isEmpty()) continue;
            names[i] = "input-" + (i + 1);
        }
        this.m_RowID.setMax(data.numAttributes());
        int rowID = this.m_RowID.getIntIndex();
        if (this.getDebug()) {
            System.out.println("row ID col (0-based, ignored if -1): " + rowID);
        }
        int[][] inputs = new int[this.m_Inputs.length][];
        if (this.getDebug()) {
            System.out.println("# of inputs: " + this.m_Inputs.length);
        }
        for (i = 0; i < this.m_Inputs.length; ++i) {
            this.m_Inputs[i].setMax(data.numAttributes());
            inputs[i] = this.m_Inputs[i].getIntIndices();
            if (!this.getDebug()) continue;
            System.out.println("input " + (i + 1) + " (0-based): " + adams.core.Utils.arrayToString((Object)inputs[i]));
        }
        int classIndex = data.classIndex();
        if (classIndex > -1 && data.classAttribute().isNominal()) {
            int numLabels = data.classAttribute().numValues();
            data = new Instances(data);
            data.setClassIndex(-1);
            NominalToBinary nom2bin = new NominalToBinary();
            nom2bin.setAttributeIndices("" + (classIndex + 1));
            nom2bin.setTransformAllValues(true);
            try {
                nom2bin.setInputFormat(data);
                data = Filter.useFilter((Instances)data, (Filter)nom2bin);
            }
            catch (Exception e) {
                throw new IOException("Failed to binarize class attribute, using: " + OptionUtils.getCommandLine((Object)nom2bin), e);
            }
            TIntArrayList affected = new TIntArrayList();
            for (i = 0; i < inputs.length; ++i) {
                for (n = 0; n < inputs[i].length; ++n) {
                    if (inputs[i][n] > classIndex) {
                        int[] nArray = inputs[i];
                        int n2 = n;
                        nArray[n2] = nArray[n2] + (numLabels - 1);
                        continue;
                    }
                    if (inputs[i][n] != classIndex || affected.contains(inputs[i][n])) continue;
                    affected.add(i);
                }
            }
            if (this.getDebug()) {
                System.out.println("Arrays affected by binarization: " + affected);
            }
            for (i = 0; i < affected.size(); ++i) {
                TIntArrayList fixed = new TIntArrayList();
                for (n = 0; n < inputs[affected.get(i)].length; ++n) {
                    fixed.add(inputs[affected.get(i)][n]);
                    if (inputs[affected.get(i)][n] != classIndex) continue;
                    for (r = 1; r < numLabels; ++r) {
                        fixed.add(classIndex + r);
                    }
                }
                if (this.getDebug()) {
                    System.out.println("Affected array #" + affected.get(i) + " (old): " + Utils.arrayToString((Object)inputs[affected.get(i)]));
                }
                inputs[affected.get((int)i)] = fixed.toArray();
                if (!this.getDebug()) continue;
                System.out.println("Affected array #" + affected.get(i) + " (fixed): " + Utils.arrayToString((Object)inputs[affected.get(i)]));
            }
        }
        TIntArrayList canOutput = new TIntArrayList();
        if (!this.m_SuppressMissing) {
            for (i = 0; i < this.m_Inputs.length; ++i) {
                canOutput.add(i);
            }
        }
        FileWriter fwriter = new FileWriter(this.m_OutputFile);
        BufferedWriter writer = new BufferedWriter(fwriter);
        r = 0;
        for (Instance row : data) {
            ++r;
            if (this.m_SuppressMissing) {
                canOutput.clear();
                for (i = 0; i < inputs.length; ++i) {
                    boolean missing = false;
                    for (n = 0; n < inputs[i].length; ++n) {
                        if (!row.isMissing(inputs[i][n])) continue;
                        missing = true;
                        break;
                    }
                    if (missing) continue;
                    canOutput.add(i);
                }
            }
            if (this.m_SuppressMissing && this.getDebug()) {
                System.out.println("Row #" + r + " / inputs to output: " + canOutput);
            }
            if (canOutput.size() == 0) continue;
            try {
                if (rowID > -1 && !row.isMissing(rowID)) {
                    writer.write(this.format(row.value(rowID)));
                    writer.write(" ");
                }
                for (int m = 0; m < canOutput.size(); ++m) {
                    i = canOutput.get(m);
                    writer.write("|");
                    writer.write(names[i]);
                    writer.write(" ");
                    for (n = 0; n < inputs[i].length; ++n) {
                        Double value = row.isMissing(inputs[i][n]) ? null : Double.valueOf(row.value(inputs[i][n]));
                        if (this.m_UseSparseFormat) {
                            if (value != null && value == 0.0) continue;
                            writer.write("" + inputs[i][n]);
                            writer.write(":");
                        }
                        if (value == null) {
                            writer.write("?");
                        } else {
                            writer.write(this.format(value));
                        }
                        writer.write(" ");
                    }
                }
                writer.write("\n");
                writer.flush();
            }
            catch (Exception e) {
                System.err.println("Failed to write data: " + row);
                e.printStackTrace();
            }
        }
        FileUtils.closeQuietly((Writer)writer);
        FileUtils.closeQuietly((Writer)fwriter);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision$");
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        CNTKSaver.runFileSaver((AbstractFileSaver)new CNTKSaver(), (String[])args);
    }
}

