/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.weka.WekaAttributeIndex;
import adams.data.weka.WekaAttributeRange;
import adams.flow.container.CNTKMultiFilterResultContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.CNTKSaver;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.unsupervised.attribute.AddID;
import weka.filters.unsupervised.attribute.PartitionedMultiFilter2;
import weka.filters.unsupervised.attribute.Remove;

public class CNTKMultiFilter
extends AbstractTransformer {
    private static final long serialVersionUID = 9077096252192331835L;
    public static final String PREFIX_TARGETS = "targets";
    public static final String PREFIX_FILTERED = "filtered";
    protected String m_DomainName;
    protected String m_DomainType;
    protected Filter[] m_Filters;
    protected BaseString[] m_Prefixes;
    protected WekaAttributeRange m_Targets;
    protected WekaAttributeIndex m_InputIDAttribute;
    protected String m_OutputIDAttribute;

    public String globalInfo() {
        return "Applies the filters to the incoming data (also adds a numeric ID column) and outputs this new dataset alongside Python code for CNTK.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("domain-name", "domainName", (Object)"");
        this.m_OptionManager.add("domain-type", "domainType", (Object)"");
        this.m_OptionManager.add("filter", "filters", (Object)new Filter[0]);
        this.m_OptionManager.add("prefix", "prefixes", (Object)new BaseString[0]);
        this.m_OptionManager.add(PREFIX_TARGETS, PREFIX_TARGETS, (Object)new WekaAttributeRange("last"));
        this.m_OptionManager.add("input-id-att", "inputIDAttribute", (Object)new WekaAttributeIndex("first"));
        this.m_OptionManager.add("output-id-att", "outputIDAttribute", (Object)"ID");
    }

    public void setDomainName(String value) {
        this.m_DomainName = value;
        this.reset();
    }

    public String getDomainName() {
        return this.m_DomainName;
    }

    public String domainNameTipText() {
        return "The name for the domain.";
    }

    public void setDomainType(String value) {
        this.m_DomainType = value;
        this.reset();
    }

    public String getDomainType() {
        return this.m_DomainType;
    }

    public String domainTypeTipText() {
        return "The type for the domain.";
    }

    public void setFilters(Filter[] value) {
        this.m_Filters = value;
        this.m_Prefixes = (BaseString[])Utils.adjustArray((Object)this.m_Prefixes, (int)this.m_Filters.length, (Object)new BaseString());
        this.reset();
    }

    public Filter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The filters to apply individually to the data (excluding targets and sample ID).";
    }

    public void setPrefixes(BaseString[] value) {
        this.m_Prefixes = value;
        this.m_Filters = (Filter[])Utils.adjustArray((Object)this.m_Filters, (int)this.m_Prefixes.length, (Object)new AllFilter());
        this.reset();
    }

    public BaseString[] getPrefixes() {
        return this.m_Prefixes;
    }

    public String prefixesTipText() {
        return "The prefixes for the attributes to use (- gets added automatically).";
    }

    public void setTargets(WekaAttributeRange value) {
        this.m_Targets = value;
        this.reset();
    }

    public WekaAttributeRange getTargets() {
        return this.m_Targets;
    }

    public String targetsTipText() {
        return "The attributes in the dataset that are considered targets.";
    }

    public void setInputIDAttribute(WekaAttributeIndex value) {
        this.m_InputIDAttribute = value;
        this.reset();
    }

    public WekaAttributeIndex getInputIDAttribute() {
        return this.m_InputIDAttribute;
    }

    public String inputIDAttributeTipText() {
        return "The attribute index in the input dataset that contains the unique ID for which to generate the ID mapping.";
    }

    public void setOutputIDAttribute(String value) {
        this.m_OutputIDAttribute = value;
        this.reset();
    }

    public String getOutputIDAttribute() {
        return this.m_OutputIDAttribute;
    }

    public String outputIDAttributeTipText() {
        return "The attribute name in the output dataset that contains the numeric unique ID for which the ID mapping was generated.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"domainName", (Object)(this.m_DomainName.isEmpty() ? "-none-" : this.m_DomainName), (String)"name: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"domainType", (Object)(this.m_DomainType.isEmpty() ? "-none-" : this.m_DomainType), (String)", type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"filters", (Object)(this.m_Filters.length + " filters"), (String)"");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)PREFIX_TARGETS, (Object)this.m_Targets, (String)", targets: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"inputIDAttribute", (Object)this.m_InputIDAttribute, (String)", input ID: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputIDAttribute", (Object)this.m_OutputIDAttribute, (String)", output ID: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{CNTKMultiFilterResultContainer.class};
    }

    protected String extractTarget(String attName) {
        return attName.replaceAll("targets-[0-9]+-", "");
    }

    protected Instances filter(Instances data) throws Exception {
        int i;
        this.m_Targets.setData((Object)data);
        TIntHashSet blacklist = new TIntHashSet(this.m_Targets.getIntIndices());
        TIntArrayList nonNumeric = new TIntArrayList();
        for (i = 0; i < data.numAttributes(); ++i) {
            if (data.attribute(i).isNumeric()) continue;
            nonNumeric.add(i);
        }
        blacklist.addAll((TIntCollection)nonNumeric);
        TIntArrayList attList = new TIntArrayList();
        for (i = 0; i < data.numAttributes(); ++i) {
            if (blacklist.contains(i)) continue;
            attList.add(i);
        }
        Range dataAtts = new Range();
        dataAtts.setMax(data.numAttributes());
        dataAtts.setIndices(attList.toArray());
        String dataRange = dataAtts.toExplicitRange();
        ArrayList<Object> filters = new ArrayList<Object>();
        for (i = 0; i < this.m_Filters.length; ++i) {
            filters.add(ObjectCopyHelper.copyObject((Object)this.m_Filters[i]));
        }
        filters.add(new AllFilter());
        ArrayList<weka.core.Range> ranges = new ArrayList<weka.core.Range>();
        for (i = 0; i < this.m_Filters.length; ++i) {
            ranges.add(new weka.core.Range(dataRange));
        }
        ranges.add(new weka.core.Range(this.m_Targets.toExplicitRange()));
        ArrayList<BaseString> prefixes = new ArrayList<BaseString>();
        for (i = 0; i < this.m_Prefixes.length; ++i) {
            prefixes.add(new BaseString(this.m_Prefixes[i].getValue()));
        }
        prefixes.add(new BaseString(PREFIX_TARGETS));
        PartitionedMultiFilter2 part = new PartitionedMultiFilter2();
        part.setFilters(filters.toArray(new Filter[0]));
        part.setRanges(ranges.toArray(new weka.core.Range[0]));
        part.setPrefixes(prefixes.toArray(new BaseString[0]));
        part.setRemoveUnused(true);
        AddID addID = new AddID();
        addID.setAttributeName(this.m_OutputIDAttribute);
        MultiFilter multi = new MultiFilter();
        multi.setFilters(new Filter[]{part, addID});
        if (this.isLoggingEnabled()) {
            this.getLogger().info("MultiFilter: " + OptionUtils.getCommandLine((Object)multi));
        }
        multi.setInputFormat(data);
        Instances filtered = Filter.useFilter((Instances)data, (Filter)multi);
        return filtered;
    }

    protected String toString(JsonObject json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)json);
    }

    protected String generateIDs(Instances data) throws Exception {
        data = new Instances(data);
        data.setClassIndex(-1);
        this.m_InputIDAttribute.setData((Object)data);
        int id = this.m_InputIDAttribute.getIntIndex();
        if (id == -1) {
            throw new IllegalStateException("Failed to locate unique ID attribute in input data: " + this.m_InputIDAttribute);
        }
        Remove remove = new Remove();
        remove.setAttributeIndicesArray(new int[]{id});
        remove.setInvertSelection(true);
        MultiFilter multi = new MultiFilter();
        multi.setFilters(new Filter[]{remove, new AddID()});
        multi.setInputFormat(data);
        Instances filtered = Filter.useFilter((Instances)data, (Filter)multi);
        JsonObject result = new JsonObject();
        for (Instance inst : filtered) {
            result.addProperty("" + (int)inst.value(0), inst.stringValue(1));
        }
        return this.toString(result);
    }

    protected CNTKSaver generateSaver(Instances filtered) {
        Range input;
        int n;
        ArrayList<Range> inputs = new ArrayList<Range>();
        ArrayList<BaseString> inputNames = new ArrayList<BaseString>();
        this.m_InputIDAttribute.setData((Object)filtered);
        inputs.add(new Range("" + (filtered.attribute(this.m_OutputIDAttribute).index() + 1)));
        inputNames.add(new BaseString(this.m_OutputIDAttribute));
        for (BaseString name : this.m_Prefixes) {
            inputNames.add(new BaseString(name.getValue()));
        }
        for (int i = 0; i < this.m_Filters.length; ++i) {
            TIntArrayList atts = new TIntArrayList();
            String prefix = this.m_Prefixes[i].getValue();
            if (prefix.trim().isEmpty()) {
                prefix = PREFIX_FILTERED;
            }
            prefix = prefix + "-" + i + "-";
            for (n = 0; n < filtered.numAttributes(); ++n) {
                if (!filtered.attribute(n).name().startsWith(prefix)) continue;
                atts.add(n);
            }
            input = new Range();
            input.setMax(filtered.numAttributes());
            input.setIndices(atts.toArray());
            inputs.add(input);
        }
        for (n = 0; n < filtered.numAttributes(); ++n) {
            if (!filtered.attribute(n).name().startsWith(PREFIX_TARGETS)) continue;
            input = new Range();
            input.setMax(filtered.numAttributes());
            input.setIndices(new int[]{n});
            inputs.add(input);
            inputNames.add(new BaseString(this.extractTarget(filtered.attribute(n).name())));
        }
        CNTKSaver result = new CNTKSaver();
        result.setInputs(inputs.toArray(new Range[0]));
        result.setInputNames(inputNames.toArray(new BaseString[0]));
        return result;
    }

    protected String generateDefinition(CNTKSaver saver, Instances filtered) {
        JsonObject result = new JsonObject();
        JsonObject map = new JsonObject();
        map.addProperty("Name", this.m_DomainName);
        map.addProperty("Type", this.m_DomainType);
        result.add("Domain", (JsonElement)map);
        result.addProperty("UniqueID", this.m_OutputIDAttribute);
        map = new JsonObject();
        for (int i = 0; i < saver.getInputNames().length; ++i) {
            Range range = saver.getInputs()[i].getClone();
            range.setMax(filtered.numAttributes());
            map.addProperty(saver.getInputNames()[i].getValue(), (Number)range.getIntIndices().length);
        }
        result.add("Inputs", (JsonElement)map);
        return this.toString(result);
    }

    protected String doExecute() {
        String result = null;
        Instances data = (Instances)this.m_InputToken.getPayload(Instances.class);
        try {
            Instances filtered = this.filter(data);
            String ids = this.generateIDs(data);
            CNTKSaver saver = this.generateSaver(filtered);
            String def = this.generateDefinition(saver, filtered);
            CNTKMultiFilterResultContainer cont = new CNTKMultiFilterResultContainer(filtered, ids, OptionUtils.getCommandLine((Object)((Object)saver)), def);
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to filter data!", e);
        }
        return result;
    }
}

