/*
 * Decompiled with CFR 0.152.
 */
package adams.data.wekapyroproxy;

import adams.core.Utils;
import adams.core.exception.NotImplementedException;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionUtils;
import adams.data.wekapyroproxy.AbstractCommunicationProcessor;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import weka.classifiers.functions.PyroProxy;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;

public class JsonAttributeBlocksCommunicationProcessor
extends AbstractCommunicationProcessor {
    private static final long serialVersionUID = -3873591854625889387L;
    protected PlaceholderFile m_DataDescriptionFile;
    protected transient Map<String, TIntList> m_DataDescription;
    protected transient Filter m_Filter;

    public String globalInfo() {
        return "Converts the Instance into JSON, generating blocks using the inputs defined by the JSON file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-description-file", "dataDescriptionFile", (Object)new PlaceholderFile());
    }

    protected void reset() {
        super.reset();
        this.m_DataDescription = null;
        this.m_Filter = null;
    }

    public void setDataDescriptionFile(PlaceholderFile value) {
        this.m_DataDescriptionFile = value;
        this.reset();
    }

    public PlaceholderFile getDataDescriptionFile() {
        return this.m_DataDescriptionFile;
    }

    public String dataDescriptionFileTipText() {
        return "The JSON file containing the dataset desription.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadDataDescription() {
        String result = null;
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(this.m_DataDescriptionFile.getAbsolutePath());
            breader = new BufferedReader(freader);
            JSONParser parser = new JSONParser(1984);
            JSONObject obj = (JSONObject)parser.parse((Reader)breader);
            JSONObject ranges = (JSONObject)obj.get((Object)"AttributeRanges");
            this.m_DataDescription = new HashMap<String, TIntList>();
            for (String key : ranges.keySet()) {
                String attsStr = ranges.getAsString(key);
                TIntArrayList atts = new TIntArrayList();
                for (String att : attsStr.split(",")) {
                    atts.add(Integer.parseInt(att) - 1);
                }
                this.m_DataDescription.put(key, (TIntList)atts);
            }
            this.m_Filter = (Filter)OptionUtils.forAnyCommandLine(Filter.class, (String)obj.getAsString("Filter"));
        }
        catch (Exception e) {
            try {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to read JSON file: " + this.m_DataDescriptionFile), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly(freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }

    protected String checkInitialize(Instances data) {
        String result = super.checkInitialize(data);
        if (result == null) {
            result = !this.m_DataDescriptionFile.exists() ? "Data description JSON file does not exist: " + this.m_DataDescriptionFile : (this.m_DataDescriptionFile.isDirectory() ? "Data description JSON file points to a directory: " + this.m_DataDescriptionFile : this.loadDataDescription());
        }
        return result;
    }

    protected void doInitialize(PyroProxy owner, Instances data) throws Exception {
        this.m_Filter.setInputFormat(data);
        Filter.useFilter((Instances)data, (Filter)this.m_Filter);
    }

    protected String checkDataset(Instances data) {
        String result = super.checkDataset(data);
        if (result == null) {
            result = !this.m_DataDescriptionFile.exists() ? "Data description JSON file does not exist: " + this.m_DataDescriptionFile : (this.m_DataDescriptionFile.isDirectory() ? "Data description JSON file points to a directory: " + this.m_DataDescriptionFile : this.loadDataDescription());
        }
        return result;
    }

    protected Object doConvertDataset(PyroProxy owner, Instances data) throws Exception {
        throw new NotImplementedException();
    }

    protected String checkInstance(Instance inst) {
        String result = super.checkInstance(inst);
        if (result == null) {
            result = !this.m_DataDescriptionFile.exists() ? "Data description JSON file does not exist: " + this.m_DataDescriptionFile : (this.m_DataDescriptionFile.isDirectory() ? "Data description JSON file points to a directory: " + this.m_DataDescriptionFile : this.loadDataDescription());
        }
        return result;
    }

    protected Object doConvertInstance(PyroProxy owner, Instance inst) throws Exception {
        if (!this.m_Filter.isFirstBatchDone()) {
            this.m_Filter.setInputFormat(inst.dataset());
            Filter.useFilter((Instances)inst.dataset(), (Filter)this.m_Filter);
        }
        this.m_Filter.input(inst);
        this.m_Filter.batchFinished();
        inst = this.m_Filter.output();
        JSONObject data = new JSONObject();
        data.put((Object)"Model", (Object)owner.getModelName());
        JSONObject blocks = new JSONObject();
        data.put((Object)"Blocks", (Object)blocks);
        for (String block : this.m_DataDescription.keySet()) {
            TIntList atts = this.m_DataDescription.get(block);
            StringBuilder values = new StringBuilder();
            for (int index : atts.toArray()) {
                if (values.length() > 0) {
                    values.append(",");
                }
                values.append("" + inst.value(index));
            }
            blocks.put((Object)block, (Object)values.toString());
        }
        String result = data.toJSONString();
        return result;
    }

    protected String checkPrediction(Object prediction) {
        String result = super.checkPrediction(prediction);
        if (result == null && !(prediction instanceof String)) {
            result = "Expected prediction to be a string, instead received: " + Utils.classToString((Object)prediction);
        }
        return result;
    }

    protected double[] doParsePrediction(PyroProxy owner, Object prediction) throws Exception {
        JSONParser parser = new JSONParser(1984);
        StringReader sreader = new StringReader((String)prediction);
        JSONObject pred = (JSONObject)parser.parse((Reader)sreader);
        if (pred.containsKey((Object)"Error")) {
            throw new Exception(pred.getAsString("Error"));
        }
        JSONArray array = (JSONArray)pred.get((Object)"Prediction");
        double[] result = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            result[i] = ((Number)array.get(i)).doubleValue();
        }
        return result;
    }

    public boolean supportsBatchPredictions() {
        return false;
    }

    protected double[][] doParsePredictions(PyroProxy owner, Object predictions) throws Exception {
        throw new NotImplementedException();
    }
}

