/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.ml.cntk.modelapplier.ImageChannels;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

@MixedCopyright(author="CNTK", copyright="Microsoft", license=License.MIT, url="https://github.com/Microsoft/CNTK/blob/v2.0/Tests/EndToEndTests/EvalClientTests/JavaEvalTest/src/Main.java")
public class DefaultCNTK
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected int m_Width;
    protected int m_Height;
    protected ImageChannels m_Channels;

    public String globalInfo() {
        return "Scales the image and turns the intensities into features (order is BGR per pixel).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)32, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)32, (Number)1, null);
        this.m_OptionManager.add("channels", "channels", (Object)ImageChannels.GRAY);
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width to scale to.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height to scale to.";
    }

    public void setChannels(ImageChannels value) {
        this.m_Channels = value;
        this.reset();
    }

    public ImageChannels getChannels() {
        return this.m_Channels;
    }

    public String channelsTipText() {
        return "The image channels to use.";
    }

    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        switch (this.m_Channels) {
            case GRAY: {
                for (int i = 0; i < this.m_Width * this.m_Height; ++i) {
                    result.add("Intensity-" + (i + 1), DataType.NUMERIC);
                }
                break;
            }
            case BGR: {
                int i;
                for (i = 0; i < this.m_Width * this.m_Height; ++i) {
                    result.add("Intensity-" + (i + 1) + "-B", DataType.NUMERIC);
                }
                for (i = 0; i < this.m_Width * this.m_Height; ++i) {
                    result.add("Intensity-" + (i + 1) + "-G", DataType.NUMERIC);
                }
                for (i = 0; i < this.m_Width * this.m_Height; ++i) {
                    result.add("Intensity-" + (i + 1) + "-R", DataType.NUMERIC);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled image channels: " + (Object)((Object)this.m_Channels));
            }
        }
        return result;
    }

    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        BufferedImage bmp = img.toBufferedImage();
        Image resized = bmp.getScaledInstance(this.m_Width, this.m_Height, 1);
        BufferedImage bImg = new BufferedImage(resized.getWidth(null), resized.getHeight(null), 1);
        bImg.getGraphics().drawImage(resized, 0, 0, null);
        switch (this.m_Channels) {
            case GRAY: {
                for (int h = 0; h < bImg.getHeight(); ++h) {
                    for (int w = 0; w < bImg.getWidth(); ++w) {
                        Color color = new Color(bImg.getRGB(w, h));
                        result[0].add(color.getBlue());
                    }
                }
                break;
            }
            case BGR: {
                for (int c = 0; c < 3; ++c) {
                    for (int h = 0; h < bImg.getHeight(); ++h) {
                        for (int w = 0; w < bImg.getWidth(); ++w) {
                            Color color = new Color(bImg.getRGB(w, h));
                            if (c == 0) {
                                result[0].add(color.getBlue());
                                continue;
                            }
                            if (c == 1) {
                                result[0].add(color.getGreen());
                                continue;
                            }
                            result[0].add(color.getRed());
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled image channels: " + (Object)((Object)this.m_Channels));
            }
        }
        return result;
    }
}

