/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.StoppableWithFeedback;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.io.lister.LocalDirectoryLister;
import adams.core.logging.LoggingObject;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.RunnableWithLogging;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.CNTKSetup;
import adams.ml.cntk.CNTK;
import com.github.fracpete.processoutput4j.core.StreamingProcessOutputType;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import com.github.fracpete.processoutput4j.output.StreamingProcessOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CNTKBrainScriptExec
extends AbstractSource
implements StreamingProcessOwner {
    private static final long serialVersionUID = -132045002653940359L;
    protected PlaceholderFile m_Script;
    protected PlaceholderFile m_TmpScript;
    protected boolean m_ScriptContainsVariables;
    protected StreamingProcessOutputType m_OutputType;
    protected String m_PrefixStdOut;
    protected String m_PrefixStdErr;
    protected boolean m_DeleteTempModels;
    protected boolean m_DeleteCheckPointFiles;
    protected PlaceholderDirectory m_ModelDirectory;
    protected String m_ModelExtension;
    protected List m_Output;
    protected StreamingProcessOutput m_ProcessOutput;
    protected RunnableWithLogging m_Monitor;
    protected IllegalStateException m_ExecutionFailure;
    protected CNTKSetup m_Setup;
    protected LocalDirectoryLister m_Lister;

    public String globalInfo() {
        return "Executes the specified BrainScript and forwards the specified process output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "script", (Object)new PlaceholderFile());
        this.m_OptionManager.add("script-contains-variables", "scriptContainsVariables", (Object)false);
        this.m_OptionManager.add("output-type", "outputType", (Object)StreamingProcessOutputType.STDERR);
        this.m_OptionManager.add("prefix-stdout", "prefixStdOut", (Object)"");
        this.m_OptionManager.add("prefix-stderr", "prefixStdErr", (Object)"");
        this.m_OptionManager.add("delete-temp-models", "deleteTempModels", (Object)false);
        this.m_OptionManager.add("delete-checkpoint-files", "deleteCheckPointFiles", (Object)false);
        this.m_OptionManager.add("model-directory", "modelDirectory", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("model-extension", "modelExtension", (Object)".cmf");
    }

    protected void initialize() {
        super.initialize();
        this.m_Output = new ArrayList();
    }

    protected void reset() {
        super.reset();
        this.m_Output.clear();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"script", (Object)this.m_Script);
    }

    public void setScript(PlaceholderFile value) {
        this.m_Script = value;
        this.reset();
    }

    public PlaceholderFile getScript() {
        return this.m_Script;
    }

    public String scriptTipText() {
        return "The BrainScript to run.";
    }

    public void setScriptContainsVariables(boolean value) {
        this.m_ScriptContainsVariables = value;
        this.reset();
    }

    public boolean getScriptContainsVariables() {
        return this.m_ScriptContainsVariables;
    }

    public String scriptContainsVariablesTipText() {
        return "If enabled, any variables that might be present in the script file get expanded first.";
    }

    public void setOutputType(StreamingProcessOutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public StreamingProcessOutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "Determines the output type; if " + StreamingProcessOutputType.BOTH + " is selected then an array is output with stdout as first element and stderr as second";
    }

    public void setPrefixStdOut(String value) {
        this.m_PrefixStdOut = value;
        this.reset();
    }

    public String getPrefixStdOut() {
        return this.m_PrefixStdOut;
    }

    public String prefixStdOutTipText() {
        return "The (optional) prefix to use for output from stdout.";
    }

    public void setPrefixStdErr(String value) {
        this.m_PrefixStdErr = value;
        this.reset();
    }

    public String getPrefixStdErr() {
        return this.m_PrefixStdErr;
    }

    public String prefixStdErrTipText() {
        return "The (optional) prefix to use for output from stderr.";
    }

    public void setDeleteTempModels(boolean value) {
        this.m_DeleteTempModels = value;
        this.reset();
    }

    public boolean getDeleteTempModels() {
        return this.m_DeleteTempModels;
    }

    public String deleteTempModelsTipText() {
        return "If enabled, any temporary models get deleted.";
    }

    public void setDeleteCheckPointFiles(boolean value) {
        this.m_DeleteCheckPointFiles = value;
        this.reset();
    }

    public boolean getDeleteCheckPointFiles() {
        return this.m_DeleteCheckPointFiles;
    }

    public String deleteCheckPointFilesTipText() {
        return "If enabled, any checkpoint files get deleted.";
    }

    public void setModelDirectory(PlaceholderDirectory value) {
        this.m_ModelDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getModelDirectory() {
        return this.m_ModelDirectory;
    }

    public String modelDirectoryTipText() {
        return "The directory containing the models, temp models and checkpoint files.";
    }

    public void setModelExtension(String value) {
        this.m_ModelExtension = value;
        this.reset();
    }

    public String getModelExtension() {
        return this.m_ModelExtension;
    }

    public String modelExtensionTipText() {
        return "The file extension used by the models (incl dot).";
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected CNTKSetup getConnection() {
        return (CNTKSetup)ActorUtils.findClosestType((Actor)this, CNTKSetup.class, (boolean)true);
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Setup = this.getConnection();
        }
        return result;
    }

    protected String preprocessScript() {
        List lines;
        String result = this.m_Script.getAbsolutePath();
        this.m_TmpScript = null;
        if (this.m_ScriptContainsVariables && (lines = FileUtils.loadFromFile((File)this.m_Script)) != null) {
            result = TempUtils.createTempFile((String)"adams-cntk-bs-", (String)".bs").getAbsolutePath();
            String content = Utils.flatten((List)lines, (String)"\n");
            content = this.getVariables().expand(content);
            String msg = FileUtils.writeToFileMsg((String)result, (Object)content, (boolean)false, null);
            if (msg != null) {
                throw new IllegalStateException("Failed to write expanded script!\n" + msg);
            }
            this.m_TmpScript = new PlaceholderFile(result);
        }
        return result;
    }

    protected String doExecute() {
        this.m_Output.clear();
        String script = this.preprocessScript();
        String cmd = this.m_Setup == null ? CNTK.getBinary().getAbsolutePath() : this.m_Setup.getBinary().getAbsolutePath();
        final String fCmd = cmd = cmd + " configFile=" + script;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Command: " + cmd);
        }
        this.m_Lister = null;
        if (this.m_DeleteTempModels || this.m_DeleteCheckPointFiles) {
            this.m_Lister = new LocalDirectoryLister();
            this.m_Lister.setWatchDir(this.m_ModelDirectory.getAbsolutePath());
            if (this.m_DeleteTempModels && this.m_DeleteCheckPointFiles) {
                this.m_Lister.setRegExp(new BaseRegExp(".*\\" + this.m_ModelExtension + "\\.([0-9]+|ckp)$"));
            } else if (this.m_DeleteTempModels) {
                this.m_Lister.setRegExp(new BaseRegExp(".*\\" + this.m_ModelExtension + "\\.[0-9]+$"));
            } else if (this.m_DeleteCheckPointFiles) {
                this.m_Lister.setRegExp(new BaseRegExp(".*\\" + this.m_ModelExtension + "\\.ckp$"));
            }
            this.m_Lister.setRecursive(false);
            this.m_Lister.setListDirs(false);
            this.m_Lister.setListFiles(true);
        }
        this.m_ExecutionFailure = null;
        this.m_ProcessOutput = new StreamingProcessOutput((StreamingProcessOwner)this);
        this.m_Monitor = new RunnableWithLogging(){
            private static final long serialVersionUID = -4475355379511760429L;
            protected Process m_Process;

            protected void doRun() {
                try {
                    this.m_Process = Runtime.getRuntime().exec(fCmd, null, null);
                    CNTKBrainScriptExec.this.m_ProcessOutput.monitor(fCmd, null, this.m_Process);
                    if (CNTKBrainScriptExec.this.m_ProcessOutput.getExitCode() != 0) {
                        CNTKBrainScriptExec.this.m_ExecutionFailure = new IllegalStateException("Exit code " + CNTKBrainScriptExec.this.m_ProcessOutput.getExitCode() + " when executing: " + fCmd);
                    }
                }
                catch (Exception e) {
                    CNTKBrainScriptExec.this.m_ExecutionFailure = new IllegalStateException("Failed to execute: " + fCmd, e);
                }
                CNTKBrainScriptExec.this.m_Monitor = null;
                CNTKBrainScriptExec.this.m_ProcessOutput = null;
                if (CNTKBrainScriptExec.this.m_TmpScript != null) {
                    CNTKBrainScriptExec.this.m_TmpScript.delete();
                }
            }

            public void stopExecution() {
                if (this.m_Process != null) {
                    this.m_Process.destroy();
                }
                super.stopExecution();
            }
        };
        new Thread((Runnable)this.m_Monitor).start();
        return null;
    }

    public void processOutput(String line, boolean stdout) {
        if (stdout) {
            this.m_Output.add(this.m_PrefixStdOut + line);
        } else {
            this.m_Output.add(this.m_PrefixStdErr + line);
        }
        if (this.m_Lister != null) {
            String[] files;
            for (String file : files = this.m_Lister.list()) {
                FileUtils.delete((String)file);
            }
        }
    }

    public Token output() {
        Token result = null;
        while (this.m_Output.size() == 0 && !this.isStopped() && this.m_Monitor != null) {
            Utils.wait((LoggingObject)this, (StoppableWithFeedback)this, (int)1000, (int)100);
        }
        if (this.m_ExecutionFailure != null) {
            IllegalStateException exc = this.m_ExecutionFailure;
            this.m_ExecutionFailure = null;
            throw exc;
        }
        if (!this.isStopped() && this.m_Output.size() > 0) {
            result = new Token(this.m_Output.get(0));
            this.m_Output.remove(0);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Output.size() > 0 || this.m_Monitor != null;
    }

    public void stopExecution() {
        if (this.m_Monitor != null) {
            this.m_Monitor.stopExecution();
        }
        super.stopExecution();
    }
}

