/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.cntk.modelapplier.AbstractModelApplier;
import adams.ml.cntk.modelapplier.DefaultImageApplier;

public class CNTKModelApplier
extends AbstractTransformer {
    private static final long serialVersionUID = 150073087183332891L;
    protected AbstractModelApplier m_Applier;

    public String globalInfo() {
        return "Uses the specified model applier on the input data and forwards the generated output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("applier", "applier", (Object)new DefaultImageApplier());
    }

    public void setApplier(AbstractModelApplier value) {
        this.m_Applier = value;
        this.reset();
    }

    public AbstractModelApplier getApplier() {
        return this.m_Applier;
    }

    public String applierTipText() {
        return "The model applier to use on the incoming data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"applier", (Object)((Object)this.m_Applier));
    }

    public Class[] accepts() {
        return new Class[]{this.m_Applier.accepts()};
    }

    public Class[] generates() {
        return new Class[]{this.m_Applier.generates()};
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Applier.setFlowContext((Actor)this);
            Object output = this.m_Applier.applyModel(this.m_InputToken.getPayload());
            this.m_OutputToken = new Token(output);
        }
        catch (Exception e) {
            result = this.handleException("Failed to use model applier!", e);
        }
        return result;
    }
}

