/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import com.microsoft.CNTK.Function;
import com.microsoft.CNTK.Variable;

public class CNTKModelInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = 3224751685849780838L;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Outputs the specified information about a CNTK model.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NAME);
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of info to output.";
    }

    public String outputArrayTipText() {
        return "Outputs the information as an array instead of one-by-one.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)"type: ");
    }

    public Class[] accepts() {
        return new Class[]{Function.class};
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case NAME: 
            case INPUTS: 
            case OUTPUT: 
            case OUTPUTS: 
            case ARGUMENTS: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected String doExecute() {
        String result = null;
        Function model = (Function)this.m_InputToken.getPayload();
        this.m_Queue.clear();
        try {
            switch (this.m_Type) {
                case NAME: {
                    this.m_Queue.add(model.getName());
                    break;
                }
                case INPUTS: {
                    for (Variable v : model.getInputs()) {
                        this.m_Queue.add(v.toString());
                    }
                    break;
                }
                case OUTPUT: {
                    this.m_Queue.add(model.getOutput().toString());
                    break;
                }
                case OUTPUTS: {
                    for (Variable v : model.getOutputs()) {
                        this.m_Queue.add(v.toString());
                    }
                    break;
                }
                case ARGUMENTS: {
                    for (Variable v : model.getArguments()) {
                        this.m_Queue.add(v.toString());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to extract information: " + (Object)((Object)this.m_Type), e);
        }
        return result;
    }

    public static enum InfoType {
        NAME,
        INPUTS,
        OUTPUT,
        OUTPUTS,
        ARGUMENTS;

    }
}

