/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.cntk.DeviceType;
import com.microsoft.CNTK.DeviceDescriptor;
import com.microsoft.CNTK.Function;
import java.io.File;

public class CNTKModelReader
extends AbstractTransformer {
    private static final long serialVersionUID = -7949607321054894441L;
    protected DeviceType m_DeviceType;
    protected long m_GPUDeviceID;

    public String globalInfo() {
        return "Reads the incoming model from disk.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("device-type", "deviceType", (Object)DeviceType.DEFAULT);
        this.m_OptionManager.add("gpu-device-id", "GPUDeviceID", (Object)0L);
    }

    public void setDeviceType(DeviceType value) {
        this.m_DeviceType = value;
        this.reset();
    }

    public DeviceType getDeviceType() {
        return this.m_DeviceType;
    }

    public String deviceTypeTipText() {
        return "The device type to use.";
    }

    public void setGPUDeviceID(long value) {
        this.m_GPUDeviceID = value;
        this.reset();
    }

    public long getGPUDeviceID() {
        return this.m_GPUDeviceID;
    }

    public String GPUDeviceIDTipText() {
        return "The GPU device ID.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"deviceType", (Object)((Object)this.m_DeviceType), (String)"device: ");
        if (this.m_DeviceType == DeviceType.GPU) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"GPUDeviceID", (Object)this.m_GPUDeviceID, (String)", ID: ");
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{File.class, String.class};
    }

    public Class[] generates() {
        return new Class[]{Function.class};
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = null;
        if (this.m_InputToken.getPayload() instanceof String) {
            file = new PlaceholderFile((String)this.m_InputToken.getPayload());
        } else if (this.m_InputToken.getPayload() instanceof File) {
            file = new PlaceholderFile((File)this.m_InputToken.getPayload());
        } else {
            result = "Unhandled input type: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (result == null) {
            DeviceDescriptor device;
            switch (this.m_DeviceType) {
                case DEFAULT: {
                    device = DeviceDescriptor.useDefaultDevice();
                    break;
                }
                case CPU: {
                    device = DeviceDescriptor.getCPUDevice();
                    break;
                }
                case GPU: {
                    device = DeviceDescriptor.getGPUDevice((long)this.m_GPUDeviceID);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled device type: " + (Object)((Object)this.m_DeviceType));
                }
            }
            try {
                Function model = Function.load((String)file.getAbsolutePath(), (DeviceDescriptor)device);
                this.m_OutputToken = new Token((Object)model);
            }
            catch (Exception e) {
                result = this.handleException("Failed to load model " + file + " for device " + (Object)((Object)this.m_DeviceType) + (this.m_DeviceType == DeviceType.GPU ? "/" + this.m_GPUDeviceID : ""), e);
            }
        }
        return result;
    }
}

