/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.Fonts;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import com.microsoft.CNTK.DeviceDescriptor;
import com.microsoft.CNTK.Function;
import com.microsoft.CNTK.Variable;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public class CNTKModelHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -2780002972029225999L;

    public String globalInfo() {
        return "Displays information about a CNTK model.";
    }

    public String[] getExtensions() {
        return new String[]{"cmf", "dnn", "model"};
    }

    protected PreviewPanel createPreview(File file) {
        JTextArea area = new JTextArea();
        area.setFont(Fonts.getMonospacedFont());
        try {
            Function model = Function.load((String)file.getAbsolutePath(), (DeviceDescriptor)DeviceDescriptor.useDefaultDevice());
            StringBuilder info = new StringBuilder();
            info.append("Arguments\n=========");
            for (Variable var : model.getArguments()) {
                info.append("\n");
                info.append(var.toString());
            }
            info.append("\n\nInputs\n======");
            for (Variable var : model.getInputs()) {
                info.append("\n");
                info.append(var.toString());
            }
            info.append("\n\nOutputs\n=======");
            for (Variable var : model.getOutputs()) {
                info.append("\n");
                info.append(var.toString());
            }
            area.setText(info.toString());
        }
        catch (Exception e) {
            area.setText("Failed to open model: " + file + "\n" + Utils.throwableToString((Throwable)e));
        }
        return new PreviewPanel((JComponent)new BaseScrollPane((Component)area), (JComponent)area);
    }
}

