/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.cntk.modelapplier;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.ml.cntk.modelapplier.AbstractModelApplier;
import adams.ml.cntk.predictionpostprocessor.PassThrough;
import adams.ml.cntk.predictionpostprocessor.PredictionPostProcessor;
import java.util.logging.Level;

@MixedCopyright(author="CNTK", copyright="Microsoft", license=License.MIT, url="https://github.com/Microsoft/CNTK/blob/v2.0/Tests/EndToEndTests/EvalClientTests/JavaEvalTest/src/Main.java")
public abstract class AbstractNumericArrayApplier<I>
extends AbstractModelApplier<I, float[]> {
    private static final long serialVersionUID = 7933924670965842681L;
    protected PredictionPostProcessor m_PostProcessor;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("post-processor", "postProcessor", (Object)this.getDefaultPostProcessor());
    }

    protected PredictionPostProcessor getDefaultPostProcessor() {
        return new PassThrough();
    }

    public void setPostProcessor(PredictionPostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public PredictionPostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to apply to the predictions.";
    }

    @Override
    public Class generates() {
        return float[].class;
    }

    @Override
    protected float[] applyModel(double[] input) {
        float[] values = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = (float)input[i];
        }
        return this.applyModel(values);
    }

    @Override
    protected float[] applyModel(float[] input) {
        try {
            float[] preds = this.m_Wrapper.predict(input);
            return this.m_PostProcessor.postProcessPrediction(preds);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to make prediction!", (Throwable)e);
            return new float[0];
        }
    }
}

