/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.cntk.modelapplier;

import adams.core.Utils;
import adams.data.statistics.StatUtils;
import adams.ml.cntk.modelapplier.AbstractNumericArrayApplier;
import gnu.trove.list.array.TFloatArrayList;

public class DefaultNumericArrayApplier
extends AbstractNumericArrayApplier<Object> {
    private static final long serialVersionUID = 6354440278825130565L;

    public String globalInfo() {
        return "Applies the model to the specified numeric array of byte, int, long, float or double values (primitives or objects).\n" + this.m_ModelLoader.automaticOrderInfo();
    }

    @Override
    public Class accepts() {
        return Object.class;
    }

    @Override
    protected float[] doApplyModel(Object input) {
        Number[] numArray;
        if (input instanceof byte[]) {
            numArray = StatUtils.toNumberArray((byte[])((byte[])input));
        } else if (input instanceof Byte[]) {
            numArray = (Number[])input;
        } else if (input instanceof int[]) {
            numArray = StatUtils.toNumberArray((int[])((int[])input));
        } else if (input instanceof Integer[]) {
            numArray = (Number[])input;
        } else if (input instanceof long[]) {
            numArray = StatUtils.toNumberArray((long[])((long[])input));
        } else if (input instanceof Long[]) {
            numArray = (Number[])input;
        } else if (input instanceof float[]) {
            numArray = StatUtils.toNumberArray((float[])((float[])input));
        } else if (input instanceof Float[]) {
            numArray = (Number[])input;
        } else if (input instanceof double[]) {
            numArray = StatUtils.toNumberArray((double[])((double[])input));
        } else if (input instanceof Double[]) {
            numArray = (Number[])input;
        } else {
            throw new IllegalStateException("Unhandled input class: " + Utils.classToString((Object)input));
        }
        TFloatArrayList values = new TFloatArrayList();
        for (int i = 0; i < numArray.length; ++i) {
            values.add(numArray[i].floatValue());
        }
        return this.applyModel(values.toArray());
    }
}

