/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.cntk.modelapplier;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.ml.cntk.modelapplier.AbstractNumericArrayApplier;
import gnu.trove.list.array.TFloatArrayList;

public class DefaultSpreadSheetRowApplier
extends AbstractNumericArrayApplier<Row> {
    private static final long serialVersionUID = 6354440278825130565L;

    public String globalInfo() {
        return "Applies the model to a row of a spreadsheet.\n" + this.m_ModelLoader.automaticOrderInfo();
    }

    @Override
    public Class accepts() {
        return SpreadSheet.class;
    }

    @Override
    protected float[] doApplyModel(Row input) {
        TFloatArrayList values = new TFloatArrayList();
        for (int i = 0; i < input.getOwner().getColumnCount(); ++i) {
            Cell cell = input.getCell(i);
            if (cell.isNumeric() && !cell.isMissing()) {
                values.add(cell.toDouble().floatValue());
                continue;
            }
            values.add(Float.NaN);
        }
        return this.applyModel(values.toArray());
    }
}

