/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.data.io.input.CNTKSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractFormattedSpreadSheetWriter;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import gnu.trove.list.array.TIntArrayList;
import java.io.Writer;
import java.util.logging.Level;

public class CNTKSpreadSheetWriter
extends AbstractFormattedSpreadSheetWriter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -756713262393228509L;
    protected SpreadSheetColumnIndex m_RowID;
    protected SpreadSheetColumnRange[] m_Inputs;
    protected BaseString[] m_InputNames;
    protected boolean m_UseSparseFormat;
    protected boolean m_SuppressMissing;

    public String globalInfo() {
        return "Outputs spreadsheets in CNTK text file format.\nRequires all cells to be numeric (apart from row ID column).\nFor more details, see:\n" + this.getTechnicalInformation();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row-id", "rowID", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("input", "inputs", (Object)new SpreadSheetColumnRange[0]);
        this.m_OptionManager.add("input-name", "inputNames", (Object)new BaseString[0]);
        this.m_OptionManager.add("use-sparse-format", "useSparseFormat", (Object)false);
        this.m_OptionManager.add("suppress-missing", "suppressMissing", (Object)false);
    }

    public void setRowID(SpreadSheetColumnIndex value) {
        this.m_RowID = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getRowID() {
        return this.m_RowID;
    }

    public String rowIDTipText() {
        return "The (optional) column to use for the row ID.";
    }

    public void setInputs(SpreadSheetColumnRange[] value) {
        this.m_Inputs = value;
        this.m_InputNames = (BaseString[])Utils.adjustArray((Object)this.m_InputNames, (int)this.m_Inputs.length, (Object)new BaseString());
        this.reset();
    }

    public SpreadSheetColumnRange[] getInputs() {
        return this.m_Inputs;
    }

    public String inputsTipText() {
        return "The column ranges determining the inputs (eg for 'features' and 'class').";
    }

    public void setInputNames(BaseString[] value) {
        this.m_InputNames = value;
        this.m_Inputs = (SpreadSheetColumnRange[])Utils.adjustArray((Object)this.m_Inputs, (int)this.m_InputNames.length, (Object)new SpreadSheetColumnRange());
        this.reset();
    }

    public BaseString[] getInputNames() {
        return this.m_InputNames;
    }

    public String inputNamesTipText() {
        return "The names of the inputs (eg 'features' and 'class').";
    }

    public void setUseSparseFormat(boolean value) {
        this.m_UseSparseFormat = value;
        this.reset();
    }

    public boolean getUseSparseFormat() {
        return this.m_UseSparseFormat;
    }

    public String useSparseFormatTipText() {
        return "If enabled, sparse format is used instead (ie 'index:value').";
    }

    public void setSuppressMissing(boolean value) {
        this.m_SuppressMissing = value;
        this.reset();
    }

    public boolean getSuppressMissing() {
        return this.m_SuppressMissing;
    }

    public String suppressMissingTipText() {
        return "If enabled, groups that contain at least one missing value get suppressed completely.";
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new CNTKSpreadSheetReader();
    }

    public String getFormatDescription() {
        return "CNTK Dataset";
    }

    public String[] getFormatExtensions() {
        return new String[]{"txt", "ctf"};
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.WRITER;
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Microsoft");
        result.setValue(TechnicalInformation.Field.TITLE, "CNTK");
        result.setValue(TechnicalInformation.Field.URL, "https://docs.microsoft.com/en-us/cognitive-toolkit/brainscript-cntktextformat-reader");
        return result;
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        int i;
        if (this.m_Inputs.length == 0) {
            this.getLogger().severe("No input ranges defined!");
            return false;
        }
        this.m_InputNames = (BaseString[])Utils.adjustArray((Object)this.m_InputNames, (int)this.m_Inputs.length, (Object)new BaseString());
        String[] names = new String[this.m_InputNames.length];
        for (i = 0; i < this.m_InputNames.length; ++i) {
            names[i] = this.m_InputNames[i].getValue();
            if (!names[i].isEmpty()) continue;
            names[i] = "input-" + (i + 1);
        }
        this.m_RowID.setData((Object)content);
        int rowID = this.m_RowID.getIntIndex();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("row ID col (0-based, ignored if -1): " + rowID);
        }
        int[][] inputs = new int[this.m_Inputs.length][];
        if (this.isLoggingEnabled()) {
            this.getLogger().info("# of inputs: " + this.m_Inputs.length);
        }
        for (i = 0; i < this.m_Inputs.length; ++i) {
            this.m_Inputs[i].setData((Object)content);
            inputs[i] = this.m_Inputs[i].getIntIndices();
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("input " + (i + 1) + " (0-based): " + Utils.arrayToString((Object)inputs[i]));
        }
        TIntArrayList canOutput = new TIntArrayList();
        if (!this.m_SuppressMissing) {
            for (i = 0; i < this.m_Inputs.length; ++i) {
                canOutput.add(i);
            }
        }
        int r = 0;
        for (Row row : content.rows()) {
            Cell cell;
            int n;
            if (this.m_Stopped) {
                return false;
            }
            ++r;
            if (this.m_SuppressMissing) {
                canOutput.clear();
                for (i = 0; i < inputs.length; ++i) {
                    boolean missing = false;
                    for (n = 0; n < inputs[i].length; ++n) {
                        cell = row.getCell(inputs[i][n]);
                        if (cell != null && !cell.isMissing()) continue;
                        missing = true;
                        break;
                    }
                    if (missing) continue;
                    canOutput.add(i);
                }
            }
            if (this.m_SuppressMissing && this.isLoggingEnabled()) {
                this.getLogger().fine("Row #" + r + " / inputs to output: " + canOutput);
            }
            if (canOutput.size() == 0) continue;
            try {
                if (rowID > -1 && (cell = row.getCell(rowID)) != null && !cell.isMissing()) {
                    writer.write(cell.getContent());
                    writer.write(" ");
                }
                for (int m = 0; m < canOutput.size(); ++m) {
                    i = canOutput.get(m);
                    writer.write("|");
                    writer.write(names[i]);
                    writer.write(" ");
                    for (n = 0; n < inputs[i].length; ++n) {
                        cell = row.getCell(inputs[i][n]);
                        Double value = cell == null || cell.isMissing() ? null : cell.toDouble();
                        if (this.m_UseSparseFormat) {
                            if (value != null && value == 0.0) continue;
                            writer.write("" + inputs[i][n]);
                            writer.write(":");
                        }
                        if (value == null) {
                            writer.write(this.m_MissingValue);
                        } else {
                            writer.write(this.format(value));
                        }
                        writer.write(" ");
                    }
                }
                writer.write("\n");
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to write data: " + row, (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

