/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.io.FileUtils;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.SearchPanel;
import adams.gui.core.SearchableBaseList;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CNTKFasterRcnnRois
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;

    public String globalInfo() {
        return "Displays the ROIs in images for CNTK FastRCNN datasets.\nRequires a pair of files '.*_img_file.*' and '.*_roi_file.*'.\nThe images listed in '.*_img_file.*' must be present as well.\nThe file with the class mapping ('class_map.txt') is optional, but helps when displaying the classes in the overlay.";
    }

    public String[] getExtensions() {
        return new String[]{"txt"};
    }

    protected PreviewPanel createPreview(File file) {
        File roiFile;
        File imgFile;
        if (file.getName().contains("_img_file")) {
            imgFile = file;
            roiFile = new File(imgFile.getAbsolutePath().replace("_img_file", "_roi_file"));
        } else if (file.getName().contains("_roi_file")) {
            roiFile = file;
            imgFile = new File(roiFile.getAbsolutePath().replace("_roi_file", "_img_file"));
        } else {
            return new NoPreviewAvailablePanel();
        }
        if (!imgFile.exists() || !roiFile.exists() || imgFile.isDirectory() || roiFile.isDirectory()) {
            return new NoPreviewAvailablePanel();
        }
        File classMapFile = new File(imgFile.getParentFile().getAbsolutePath() + File.separator + "class_map.txt");
        if (!classMapFile.exists() || classMapFile.isDirectory()) {
            classMapFile = null;
        }
        RoiPanel panel = new RoiPanel(this);
        panel.display(imgFile, roiFile, classMapFile);
        return new PreviewPanel((JComponent)((Object)panel), (JComponent)((Object)panel));
    }

    public static class RoiPanel
    extends BasePanel
    implements LoggingSupporter {
        private static final long serialVersionUID = 5600226296229769527L;
        protected Logger m_Logger;
        protected BaseSplitPane m_SplitPane;
        protected SearchableBaseList m_ListIndices;
        protected DefaultListModel<String> m_ModelIndices;
        protected SearchPanel m_PanelSearch;
        protected ImagePanel m_PanelImage;
        protected Map<String, File> m_MapImages;
        protected Map<String, Report> m_MapROIs;

        public RoiPanel(CNTKFasterRcnnRois owner) {
            this.m_Logger = owner.getLogger();
        }

        protected void initialize() {
            super.initialize();
            this.m_MapImages = new HashMap<String, File>();
            this.m_MapROIs = new HashMap<String, Report>();
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_SplitPane = new BaseSplitPane(1);
            this.m_SplitPane.setResizeWeight(0.0);
            this.m_SplitPane.setDividerLocation(100);
            this.add((Component)this.m_SplitPane, "Center");
            JPanel panelIndices = new JPanel(new BorderLayout());
            this.m_SplitPane.setLeftComponent((Component)panelIndices);
            this.m_ModelIndices = new DefaultListModel();
            this.m_ListIndices = new SearchableBaseList(this.m_ModelIndices);
            this.m_ListIndices.addListSelectionListener(e -> this.updateImage());
            panelIndices.add((Component)new BaseScrollPane((Component)this.m_ListIndices), "Center");
            this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false, "", true, "");
            this.m_PanelSearch.addSearchListener(e -> this.search(e.getParameters().getSearchString()));
            panelIndices.add((Component)this.m_PanelSearch, "South");
            ObjectLocationsOverlayFromReport overlay = new ObjectLocationsOverlayFromReport();
            overlay.setLabelFormat("#. $");
            overlay.setUseColorsPerType(true);
            this.m_PanelImage = new ImagePanel();
            this.m_PanelImage.addImageOverlay((ImageOverlay)overlay);
            this.m_PanelImage.setScale(-1.0);
            if (this.m_PanelImage.isUndoSupported()) {
                this.m_PanelImage.getUndo().setEnabled(false);
            }
            this.m_SplitPane.setRightComponent((Component)this.m_PanelImage);
        }

        public synchronized Logger getLogger() {
            return this.m_Logger;
        }

        public boolean isLoggingEnabled() {
            return LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.INFO);
        }

        protected void search(String s) {
            this.m_ListIndices.search(s, false);
        }

        protected void updateImage() {
            this.m_PanelImage.clear();
            this.m_PanelImage.setAdditionalProperties(null);
            if (this.m_ListIndices.getSelectedIndex() == -1) {
                return;
            }
            String key = this.m_ListIndices.getSelectedValue().toString().split(" - ")[0];
            if (!this.m_MapImages.containsKey(key) || !this.m_MapROIs.containsKey(key)) {
                return;
            }
            this.m_PanelImage.load(this.m_MapImages.get(key));
            this.m_PanelImage.setAdditionalProperties(this.m_MapROIs.get(key));
        }

        public void display(File imgFile, File roiFile, File classMapFile) {
            String[] parts;
            List lines;
            this.m_MapImages.clear();
            this.m_MapROIs.clear();
            HashMap<String, String> classes = new HashMap<String, String>();
            if (classMapFile != null) {
                lines = FileUtils.loadFromFile((File)classMapFile);
                if (lines == null) {
                    this.getLogger().severe("Failed to read: " + classMapFile);
                    return;
                }
                for (String line : lines) {
                    if (line.trim().length() == 0 || (parts = line.split("\t")).length != 2) continue;
                    classes.put(parts[1].trim(), parts[0].trim());
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Reading img file: " + imgFile);
            }
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> keysLong = new ArrayList<String>();
            lines = FileUtils.loadFromFile((File)imgFile);
            if (lines == null) {
                this.getLogger().severe("Failed to read: " + imgFile);
                return;
            }
            for (String line : lines) {
                parts = line.split("\t");
                if (parts.length != 3) continue;
                keys.add(parts[0].trim());
                keysLong.add(parts[0].trim() + " - " + parts[1].trim());
                this.m_MapImages.put(parts[0].trim(), new File(imgFile.getParentFile().getAbsolutePath() + File.separator + parts[1]));
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Reading roi file: " + roiFile);
            }
            if ((lines = FileUtils.loadFromFile((File)roiFile)) == null) {
                this.getLogger().severe("Failed to read: " + roiFile);
                return;
            }
            for (String line : lines) {
                parts = line.split("\\|");
                if (parts.length != 2) continue;
                LocatedObjects objs = new LocatedObjects();
                String[] rois = parts[1].replace("roiAndLabel", "").trim().split(" ");
                int i = 0;
                while (i + 3 < rois.length) {
                    try {
                        int x0 = Integer.parseInt(rois[i]);
                        int y0 = Integer.parseInt(rois[i + 1]);
                        int x1 = Integer.parseInt(rois[i + 2]);
                        int y1 = Integer.parseInt(rois[i + 3]);
                        LocatedObject obj = new LocatedObject(null, x0, y0, x1 - x0 + 1, y1 - y0 + 1);
                        obj.getMetaData().put("image index", parts[0].trim());
                        obj.getMetaData().put("type", classes.getOrDefault(rois[i + 4], rois[i + 4]));
                        objs.add((Object)obj);
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Failed to parse rois starting at position #" + i + "!", (Throwable)e);
                    }
                    i += 5;
                }
                this.m_MapROIs.put(parts[0].trim(), objs.toReport("Object."));
            }
            this.m_PanelImage.clear();
            this.m_ModelIndices = new DefaultListModel();
            for (String key : keysLong) {
                this.m_ModelIndices.addElement(key);
            }
            this.m_ListIndices.setModel(this.m_ModelIndices);
            if (keys.size() > 0) {
                this.m_ListIndices.setSelectedIndex(0);
            }
        }
    }
}

